// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** file. */
@Fluent
public final class MicrosoftGraphFile {
    /*
     * hashes
     */
    @JsonProperty(value = "hashes")
    private MicrosoftGraphHashes hashes;

    /*
     * The MIME type for the file. This is determined by logic on the server
     * and might not be the value provided when the file was uploaded.
     * Read-only.
     */
    @JsonProperty(value = "mimeType")
    private String mimeType;

    /*
     * The processingMetadata property.
     */
    @JsonProperty(value = "processingMetadata")
    private Boolean processingMetadata;

    /*
     * file
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the hashes property: hashes.
     *
     * @return the hashes value.
     */
    public MicrosoftGraphHashes hashes() {
        return this.hashes;
    }

    /**
     * Set the hashes property: hashes.
     *
     * @param hashes the hashes value to set.
     * @return the MicrosoftGraphFile object itself.
     */
    public MicrosoftGraphFile withHashes(MicrosoftGraphHashes hashes) {
        this.hashes = hashes;
        return this;
    }

    /**
     * Get the mimeType property: The MIME type for the file. This is determined by logic on the server and might not be
     * the value provided when the file was uploaded. Read-only.
     *
     * @return the mimeType value.
     */
    public String mimeType() {
        return this.mimeType;
    }

    /**
     * Set the mimeType property: The MIME type for the file. This is determined by logic on the server and might not be
     * the value provided when the file was uploaded. Read-only.
     *
     * @param mimeType the mimeType value to set.
     * @return the MicrosoftGraphFile object itself.
     */
    public MicrosoftGraphFile withMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    /**
     * Get the processingMetadata property: The processingMetadata property.
     *
     * @return the processingMetadata value.
     */
    public Boolean processingMetadata() {
        return this.processingMetadata;
    }

    /**
     * Set the processingMetadata property: The processingMetadata property.
     *
     * @param processingMetadata the processingMetadata value to set.
     * @return the MicrosoftGraphFile object itself.
     */
    public MicrosoftGraphFile withProcessingMetadata(Boolean processingMetadata) {
        this.processingMetadata = processingMetadata;
        return this;
    }

    /**
     * Get the additionalProperties property: file.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: file.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphFile object itself.
     */
    public MicrosoftGraphFile withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (hashes() != null) {
            hashes().validate();
        }
    }
}
