/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.ServicePrincipalsClient;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalInner;
import com.azure.resourcemanager.authorization.implementation.ServicePrincipalImpl;
import com.azure.resourcemanager.authorization.models.ServicePrincipal;
import com.azure.resourcemanager.authorization.models.ServicePrincipals;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

public class ServicePrincipalsImpl
extends CreatableWrappersImpl<ServicePrincipal, ServicePrincipalImpl, ServicePrincipalInner>
implements ServicePrincipals,
HasManager<AuthorizationManager> {
    private ServicePrincipalsClient innerCollection;
    private AuthorizationManager manager;

    public ServicePrincipalsImpl(ServicePrincipalsClient client, AuthorizationManager authorizationManager) {
        this.innerCollection = client;
        this.manager = authorizationManager;
    }

    public PagedIterable<ServicePrincipal> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<ServicePrincipal> listAsync() {
        return PagedConverter.flatMapPage(this.inner().listAsync(), servicePrincipalInner -> {
            ServicePrincipalImpl servicePrincipal = this.wrapModel((ServicePrincipalInner)servicePrincipalInner);
            return servicePrincipal.refreshCredentialsAsync().thenReturn((Object)servicePrincipal);
        });
    }

    protected ServicePrincipalImpl wrapModel(ServicePrincipalInner servicePrincipalInner) {
        if (servicePrincipalInner == null) {
            return null;
        }
        return new ServicePrincipalImpl(servicePrincipalInner, this.manager());
    }

    public ServicePrincipalImpl getById(String id) {
        return (ServicePrincipalImpl)this.getByIdAsync(id).block();
    }

    public Mono<ServicePrincipal> getByIdAsync(String id) {
        return this.innerCollection.getAsync(id).flatMap(servicePrincipalInner -> new ServicePrincipalImpl((ServicePrincipalInner)servicePrincipalInner, this.manager()).refreshCredentialsAsync());
    }

    public ServicePrincipal getByName(String spn) {
        return (ServicePrincipal)this.getByNameAsync(spn).block();
    }

    public Mono<ServicePrincipal> getByNameAsync(String name) {
        return this.inner().listAsync(String.format("servicePrincipalNames/any(c:c eq '%s')", name)).singleOrEmpty().switchIfEmpty(Mono.defer(() -> this.inner().listAsync(String.format("displayName eq '%s'", name)).singleOrEmpty())).map(servicePrincipalInner -> new ServicePrincipalImpl((ServicePrincipalInner)servicePrincipalInner, this.manager())).flatMap(servicePrincipal -> servicePrincipal.refreshCredentialsAsync());
    }

    public ServicePrincipalImpl define(String name) {
        return new ServicePrincipalImpl(new ServicePrincipalInner().withDisplayName(name), this.manager());
    }

    protected ServicePrincipalImpl wrapModel(String name) {
        return new ServicePrincipalImpl(new ServicePrincipalInner().withDisplayName(name), this.manager());
    }

    public Mono<Void> deleteByIdAsync(String id) {
        return this.inner().deleteAsync(id);
    }

    public AuthorizationManager manager() {
        return this.manager;
    }

    public ServicePrincipalsClient inner() {
        return this.manager().serviceClient().getServicePrincipals();
    }

    public PagedIterable<ServicePrincipal> listByFilter(String filter) {
        return new PagedIterable(this.listByFilterAsync(filter));
    }

    public PagedFlux<ServicePrincipal> listByFilterAsync(String filter) {
        return PagedConverter.flatMapPage(this.inner().listAsync(filter), servicePrincipalInner -> {
            ServicePrincipalImpl servicePrincipal = this.wrapModel((ServicePrincipalInner)servicePrincipalInner);
            return servicePrincipal.refreshCredentialsAsync().thenReturn((Object)servicePrincipal);
        });
    }
}

