/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.OAuth2PermissionGrantsClient;
import com.azure.resourcemanager.authorization.fluent.models.OAuth2PermissionGrantInner;
import com.azure.resourcemanager.authorization.implementation.GraphRbacManagementClientImpl;
import com.azure.resourcemanager.authorization.models.GraphErrorException;
import com.azure.resourcemanager.authorization.models.OAuth2PermissionGrantListResult;
import reactor.core.publisher.Mono;

public final class OAuth2PermissionGrantsClientImpl
implements OAuth2PermissionGrantsClient {
    private final ClientLogger logger = new ClientLogger(OAuth2PermissionGrantsClientImpl.class);
    private final OAuth2PermissionGrantsService service;
    private final GraphRbacManagementClientImpl client;

    OAuth2PermissionGrantsClientImpl(GraphRbacManagementClientImpl client) {
        this.service = (OAuth2PermissionGrantsService)RestProxy.create(OAuth2PermissionGrantsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<OAuth2PermissionGrantInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OAuth2PermissionGrantListResult)res.getValue()).value(), ((OAuth2PermissionGrantListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<OAuth2PermissionGrantInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OAuth2PermissionGrantListResult)res.getValue()).value(), ((OAuth2PermissionGrantListResult)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<OAuth2PermissionGrantInner> listAsync(String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<OAuth2PermissionGrantInner> listAsync() {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<OAuth2PermissionGrantInner> listAsync(String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<OAuth2PermissionGrantInner> list(String filter, Context context) {
        return new PagedIterable(this.listAsync(filter, context));
    }

    @Override
    public PagedIterable<OAuth2PermissionGrantInner> list() {
        String filter = null;
        return new PagedIterable(this.listAsync(filter));
    }

    @Override
    public Mono<Response<OAuth2PermissionGrantInner>> createWithResponseAsync(OAuth2PermissionGrantInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), body, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<OAuth2PermissionGrantInner>> createWithResponseAsync(OAuth2PermissionGrantInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), body, context);
    }

    @Override
    public Mono<OAuth2PermissionGrantInner> createAsync(OAuth2PermissionGrantInner body) {
        return this.createWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((OAuth2PermissionGrantInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<OAuth2PermissionGrantInner> createAsync() {
        OAuth2PermissionGrantInner body = null;
        return this.createWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((OAuth2PermissionGrantInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public OAuth2PermissionGrantInner create() {
        OAuth2PermissionGrantInner body = null;
        return (OAuth2PermissionGrantInner)this.createAsync(body).block();
    }

    @Override
    public Response<OAuth2PermissionGrantInner> createWithResponse(OAuth2PermissionGrantInner body, Context context) {
        return (Response)this.createWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String objectId) {
        return this.deleteWithResponseAsync(objectId).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String objectId) {
        this.deleteAsync(objectId).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String objectId, Context context) {
        return (Response)this.deleteWithResponseAsync(objectId, context).block();
    }

    private Mono<PagedResponse<OAuth2PermissionGrantInner>> listNextSinglePageAsync(String nextLink) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OAuth2PermissionGrantListResult)res.getValue()).value(), ((OAuth2PermissionGrantListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<OAuth2PermissionGrantInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OAuth2PermissionGrantListResult)res.getValue()).value(), ((OAuth2PermissionGrantListResult)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="GraphRbacManagementC")
    private static interface OAuth2PermissionGrantsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/oauth2PermissionGrants")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OAuth2PermissionGrantListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/{tenantID}/oauth2PermissionGrants")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OAuth2PermissionGrantInner>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="tenantID") String var3, @BodyParam(value="application/json") OAuth2PermissionGrantInner var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{tenantID}/oauth2PermissionGrants/{objectId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<OAuth2PermissionGrantListResult>> listNext(@HostParam(value="$host") String var1, @PathParam(value="nextLink", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);
    }
}

