/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.ApplicationsClient;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationInner;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryApplicationImpl;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryApplication;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryApplications;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.UUID;
import reactor.core.publisher.Mono;

public class ActiveDirectoryApplicationsImpl
extends CreatableResourcesImpl<ActiveDirectoryApplication, ActiveDirectoryApplicationImpl, ApplicationInner>
implements ActiveDirectoryApplications,
HasManager<AuthorizationManager> {
    private ApplicationsClient innerCollection;
    private AuthorizationManager manager;

    public ActiveDirectoryApplicationsImpl(ApplicationsClient client, AuthorizationManager authorizationManager) {
        this.innerCollection = client;
        this.manager = authorizationManager;
    }

    public PagedIterable<ActiveDirectoryApplication> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<ActiveDirectoryApplication> listAsync() {
        return PagedConverter.flatMapPage(this.inner().listAsync(), applicationInner -> {
            ActiveDirectoryApplicationImpl application = this.wrapModel((ApplicationInner)applicationInner);
            return application.refreshCredentialsAsync().thenReturn((Object)application);
        });
    }

    protected ActiveDirectoryApplicationImpl wrapModel(ApplicationInner applicationInner) {
        if (applicationInner == null) {
            return null;
        }
        return new ActiveDirectoryApplicationImpl(applicationInner, this.manager());
    }

    public ActiveDirectoryApplicationImpl getById(String id) {
        return (ActiveDirectoryApplicationImpl)this.getByIdAsync(id).block();
    }

    public Mono<ActiveDirectoryApplication> getByIdAsync(String id) {
        return this.innerCollection.getAsync(id).flatMap(applicationInner -> new ActiveDirectoryApplicationImpl((ApplicationInner)applicationInner, this.manager()).refreshCredentialsAsync());
    }

    public ActiveDirectoryApplication getByName(String spn) {
        return (ActiveDirectoryApplication)this.getByNameAsync(spn).block();
    }

    public Mono<ActiveDirectoryApplication> getByNameAsync(String name) {
        String trimmed = name.replaceFirst("^'+", "").replaceAll("'+$", "");
        return this.inner().listAsync(String.format("displayName eq '%s'", trimmed)).singleOrEmpty().switchIfEmpty(Mono.defer(() -> {
            try {
                UUID.fromString(trimmed);
                return this.inner().listAsync(String.format("appId eq '%s'", trimmed)).singleOrEmpty();
            }
            catch (IllegalArgumentException e) {
                return Mono.empty();
            }
        })).map(applicationInner -> new ActiveDirectoryApplicationImpl((ApplicationInner)applicationInner, this.manager())).flatMap(activeDirectoryApplication -> activeDirectoryApplication.refreshCredentialsAsync());
    }

    protected ActiveDirectoryApplicationImpl wrapModel(String name) {
        return new ActiveDirectoryApplicationImpl(new ApplicationInner().withDisplayName(name), this.manager());
    }

    public Mono<Void> deleteByIdAsync(String id) {
        return this.inner().deleteAsync(id);
    }

    public ActiveDirectoryApplicationImpl define(String name) {
        return this.wrapModel(name);
    }

    public AuthorizationManager manager() {
        return this.manager;
    }

    public ApplicationsClient inner() {
        return this.innerCollection;
    }

    public PagedIterable<ActiveDirectoryApplication> listByFilter(String filter) {
        return new PagedIterable(this.listByFilterAsync(filter));
    }

    public PagedFlux<ActiveDirectoryApplication> listByFilterAsync(String filter) {
        return PagedConverter.flatMapPage(this.inner().listAsync(filter), applicationInner -> {
            ActiveDirectoryApplicationImpl application = this.wrapModel((ApplicationInner)applicationInner);
            return application.refreshCredentialsAsync().thenReturn((Object)application);
        });
    }
}

