/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.arizeaiobservabilityeval.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.arizeaiobservabilityeval.ArizeAIObservabilityEvalManager;
import com.azure.resourcemanager.arizeaiobservabilityeval.fluent.models.OrganizationResourceInner;
import com.azure.resourcemanager.arizeaiobservabilityeval.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.arizeaiobservabilityeval.models.ManagedServiceIdentity;
import com.azure.resourcemanager.arizeaiobservabilityeval.models.OrganizationProperties;
import com.azure.resourcemanager.arizeaiobservabilityeval.models.OrganizationResource;
import com.azure.resourcemanager.arizeaiobservabilityeval.models.OrganizationResourceUpdate;
import java.util.Collections;
import java.util.Map;

public final class OrganizationResourceImpl
implements OrganizationResource,
OrganizationResource.Definition,
OrganizationResource.Update {
    private OrganizationResourceInner innerObject;
    private final ArizeAIObservabilityEvalManager serviceManager;
    private String resourceGroupName;
    private String organizationname;
    private OrganizationResourceUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public OrganizationProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public OrganizationResourceInner innerModel() {
        return this.innerObject;
    }

    private ArizeAIObservabilityEvalManager manager() {
        return this.serviceManager;
    }

    @Override
    public OrganizationResourceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public OrganizationResource create() {
        this.innerObject = this.serviceManager.serviceClient().getOrganizations().createOrUpdate(this.resourceGroupName, this.organizationname, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public OrganizationResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getOrganizations().createOrUpdate(this.resourceGroupName, this.organizationname, this.innerModel(), context);
        return this;
    }

    OrganizationResourceImpl(String name, ArizeAIObservabilityEvalManager serviceManager) {
        this.innerObject = new OrganizationResourceInner();
        this.serviceManager = serviceManager;
        this.organizationname = name;
    }

    @Override
    public OrganizationResourceImpl update() {
        this.updateProperties = new OrganizationResourceUpdate();
        return this;
    }

    @Override
    public OrganizationResource apply() {
        this.innerObject = (OrganizationResourceInner)((Object)this.serviceManager.serviceClient().getOrganizations().updateWithResponse(this.resourceGroupName, this.organizationname, this.updateProperties, Context.NONE).getValue());
        return this;
    }

    @Override
    public OrganizationResource apply(Context context) {
        this.innerObject = (OrganizationResourceInner)((Object)this.serviceManager.serviceClient().getOrganizations().updateWithResponse(this.resourceGroupName, this.organizationname, this.updateProperties, context).getValue());
        return this;
    }

    OrganizationResourceImpl(OrganizationResourceInner innerObject, ArizeAIObservabilityEvalManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.organizationname = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "organizations");
    }

    @Override
    public OrganizationResource refresh() {
        this.innerObject = (OrganizationResourceInner)((Object)this.serviceManager.serviceClient().getOrganizations().getByResourceGroupWithResponse(this.resourceGroupName, this.organizationname, Context.NONE).getValue());
        return this;
    }

    @Override
    public OrganizationResource refresh(Context context) {
        this.innerObject = (OrganizationResourceInner)((Object)this.serviceManager.serviceClient().getOrganizations().getByResourceGroupWithResponse(this.resourceGroupName, this.organizationname, context).getValue());
        return this;
    }

    @Override
    public OrganizationResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public OrganizationResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public OrganizationResourceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public OrganizationResourceImpl withProperties(OrganizationProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public OrganizationResourceImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateProperties.withIdentity(identity);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

