/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.SiteSourceControlProperties;
import com.azure.resourcemanager.appservice.models.GitHubActionConfiguration;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class SiteSourceControlInner
extends ProxyOnlyResource {
    private SiteSourceControlProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private SiteSourceControlProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public SiteSourceControlInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String repoUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().repoUrl();
    }

    public SiteSourceControlInner withRepoUrl(String repoUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteSourceControlProperties();
        }
        this.innerProperties().withRepoUrl(repoUrl);
        return this;
    }

    public String branch() {
        return this.innerProperties() == null ? null : this.innerProperties().branch();
    }

    public SiteSourceControlInner withBranch(String branch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteSourceControlProperties();
        }
        this.innerProperties().withBranch(branch);
        return this;
    }

    public Boolean isManualIntegration() {
        return this.innerProperties() == null ? null : this.innerProperties().isManualIntegration();
    }

    public SiteSourceControlInner withIsManualIntegration(Boolean isManualIntegration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteSourceControlProperties();
        }
        this.innerProperties().withIsManualIntegration(isManualIntegration);
        return this;
    }

    public Boolean isGitHubAction() {
        return this.innerProperties() == null ? null : this.innerProperties().isGitHubAction();
    }

    public SiteSourceControlInner withIsGitHubAction(Boolean isGitHubAction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteSourceControlProperties();
        }
        this.innerProperties().withIsGitHubAction(isGitHubAction);
        return this;
    }

    public Boolean deploymentRollbackEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentRollbackEnabled();
    }

    public SiteSourceControlInner withDeploymentRollbackEnabled(Boolean deploymentRollbackEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteSourceControlProperties();
        }
        this.innerProperties().withDeploymentRollbackEnabled(deploymentRollbackEnabled);
        return this;
    }

    public Boolean isMercurial() {
        return this.innerProperties() == null ? null : this.innerProperties().isMercurial();
    }

    public SiteSourceControlInner withIsMercurial(Boolean isMercurial) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteSourceControlProperties();
        }
        this.innerProperties().withIsMercurial(isMercurial);
        return this;
    }

    public GitHubActionConfiguration gitHubActionConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().gitHubActionConfiguration();
    }

    public SiteSourceControlInner withGitHubActionConfiguration(GitHubActionConfiguration gitHubActionConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteSourceControlProperties();
        }
        this.innerProperties().withGitHubActionConfiguration(gitHubActionConfiguration);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SiteSourceControlInner fromJson(JsonReader jsonReader) throws IOException {
        return (SiteSourceControlInner)((Object)jsonReader.readObject(reader -> {
            SiteSourceControlInner deserializedSiteSourceControlInner = new SiteSourceControlInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSiteSourceControlInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSiteSourceControlInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSiteSourceControlInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedSiteSourceControlInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSiteSourceControlInner.innerProperties = SiteSourceControlProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteSourceControlInner;
        }));
    }
}

