/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionKeyProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class HybridConnectionKeyInner
extends ProxyOnlyResource {
    private HybridConnectionKeyProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private HybridConnectionKeyProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public HybridConnectionKeyInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String sendKeyName() {
        return this.innerProperties() == null ? null : this.innerProperties().sendKeyName();
    }

    public String sendKeyValue() {
        return this.innerProperties() == null ? null : this.innerProperties().sendKeyValue();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static HybridConnectionKeyInner fromJson(JsonReader jsonReader) throws IOException {
        return (HybridConnectionKeyInner)((Object)jsonReader.readObject(reader -> {
            HybridConnectionKeyInner deserializedHybridConnectionKeyInner = new HybridConnectionKeyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedHybridConnectionKeyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedHybridConnectionKeyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHybridConnectionKeyInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedHybridConnectionKeyInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedHybridConnectionKeyInner.innerProperties = HybridConnectionKeyProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHybridConnectionKeyInner;
        }));
    }
}

