/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ContentLink;
import com.azure.resourcemanager.appservice.models.Correlation;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class WorkflowRunTrigger
implements JsonSerializable<WorkflowRunTrigger> {
    private String name;
    private Object inputs;
    private ContentLink inputsLink;
    private Object outputs;
    private ContentLink outputsLink;
    private OffsetDateTime scheduledTime;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String trackingId;
    private Correlation correlation;
    private String code;
    private WorkflowStatus status;
    private Object error;
    private Object trackedProperties;

    public String name() {
        return this.name;
    }

    public Object inputs() {
        return this.inputs;
    }

    public ContentLink inputsLink() {
        return this.inputsLink;
    }

    public Object outputs() {
        return this.outputs;
    }

    public ContentLink outputsLink() {
        return this.outputsLink;
    }

    public OffsetDateTime scheduledTime() {
        return this.scheduledTime;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public String trackingId() {
        return this.trackingId;
    }

    public Correlation correlation() {
        return this.correlation;
    }

    public WorkflowRunTrigger withCorrelation(Correlation correlation) {
        this.correlation = correlation;
        return this;
    }

    public String code() {
        return this.code;
    }

    public WorkflowStatus status() {
        return this.status;
    }

    public Object error() {
        return this.error;
    }

    public Object trackedProperties() {
        return this.trackedProperties;
    }

    public void validate() {
        if (this.inputsLink() != null) {
            this.inputsLink().validate();
        }
        if (this.outputsLink() != null) {
            this.outputsLink().validate();
        }
        if (this.correlation() != null) {
            this.correlation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("correlation", (JsonSerializable)this.correlation);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowRunTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowRunTrigger)jsonReader.readObject(reader -> {
            WorkflowRunTrigger deserializedWorkflowRunTrigger = new WorkflowRunTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.name = reader.getString();
                    continue;
                }
                if ("inputs".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.inputs = reader.readUntyped();
                    continue;
                }
                if ("inputsLink".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.inputsLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.outputs = reader.readUntyped();
                    continue;
                }
                if ("outputsLink".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.outputsLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("scheduledTime".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.scheduledTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("trackingId".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.trackingId = reader.getString();
                    continue;
                }
                if ("correlation".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.correlation = Correlation.fromJson(reader);
                    continue;
                }
                if ("code".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.code = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.status = WorkflowStatus.fromString(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.error = reader.readUntyped();
                    continue;
                }
                if ("trackedProperties".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.trackedProperties = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowRunTrigger;
        });
    }
}

