/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WebSiteInstanceStatusInner;
import java.io.IOException;
import java.util.List;

public final class WebAppInstanceStatusCollection
implements JsonSerializable<WebAppInstanceStatusCollection> {
    private List<WebSiteInstanceStatusInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(WebAppInstanceStatusCollection.class);

    public List<WebSiteInstanceStatusInner> value() {
        return this.value;
    }

    public WebAppInstanceStatusCollection withValue(List<WebSiteInstanceStatusInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model WebAppInstanceStatusCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WebAppInstanceStatusCollection fromJson(JsonReader jsonReader) throws IOException {
        return (WebAppInstanceStatusCollection)jsonReader.readObject(reader -> {
            WebAppInstanceStatusCollection deserializedWebAppInstanceStatusCollection = new WebAppInstanceStatusCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedWebAppInstanceStatusCollection.value = value = reader.readArray(reader1 -> WebSiteInstanceStatusInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedWebAppInstanceStatusCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebAppInstanceStatusCollection;
        });
    }
}

