/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.FunctionsAlwaysReadyConfig;
import com.azure.resourcemanager.appservice.models.FunctionsScaleAndConcurrencyTriggers;
import java.io.IOException;
import java.util.List;

public final class FunctionsScaleAndConcurrency
implements JsonSerializable<FunctionsScaleAndConcurrency> {
    private List<FunctionsAlwaysReadyConfig> alwaysReady;
    private Integer maximumInstanceCount;
    private Integer instanceMemoryMB;
    private FunctionsScaleAndConcurrencyTriggers triggers;

    public List<FunctionsAlwaysReadyConfig> alwaysReady() {
        return this.alwaysReady;
    }

    public FunctionsScaleAndConcurrency withAlwaysReady(List<FunctionsAlwaysReadyConfig> alwaysReady) {
        this.alwaysReady = alwaysReady;
        return this;
    }

    public Integer maximumInstanceCount() {
        return this.maximumInstanceCount;
    }

    public FunctionsScaleAndConcurrency withMaximumInstanceCount(Integer maximumInstanceCount) {
        this.maximumInstanceCount = maximumInstanceCount;
        return this;
    }

    public Integer instanceMemoryMB() {
        return this.instanceMemoryMB;
    }

    public FunctionsScaleAndConcurrency withInstanceMemoryMB(Integer instanceMemoryMB) {
        this.instanceMemoryMB = instanceMemoryMB;
        return this;
    }

    public FunctionsScaleAndConcurrencyTriggers triggers() {
        return this.triggers;
    }

    public FunctionsScaleAndConcurrency withTriggers(FunctionsScaleAndConcurrencyTriggers triggers) {
        this.triggers = triggers;
        return this;
    }

    public void validate() {
        if (this.alwaysReady() != null) {
            this.alwaysReady().forEach(e -> e.validate());
        }
        if (this.triggers() != null) {
            this.triggers().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("alwaysReady", this.alwaysReady, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("maximumInstanceCount", (Number)this.maximumInstanceCount);
        jsonWriter.writeNumberField("instanceMemoryMB", (Number)this.instanceMemoryMB);
        jsonWriter.writeJsonField("triggers", (JsonSerializable)this.triggers);
        return jsonWriter.writeEndObject();
    }

    public static FunctionsScaleAndConcurrency fromJson(JsonReader jsonReader) throws IOException {
        return (FunctionsScaleAndConcurrency)jsonReader.readObject(reader -> {
            FunctionsScaleAndConcurrency deserializedFunctionsScaleAndConcurrency = new FunctionsScaleAndConcurrency();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("alwaysReady".equals(fieldName)) {
                    List alwaysReady;
                    deserializedFunctionsScaleAndConcurrency.alwaysReady = alwaysReady = reader.readArray(reader1 -> FunctionsAlwaysReadyConfig.fromJson(reader1));
                    continue;
                }
                if ("maximumInstanceCount".equals(fieldName)) {
                    deserializedFunctionsScaleAndConcurrency.maximumInstanceCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("instanceMemoryMB".equals(fieldName)) {
                    deserializedFunctionsScaleAndConcurrency.instanceMemoryMB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("triggers".equals(fieldName)) {
                    deserializedFunctionsScaleAndConcurrency.triggers = FunctionsScaleAndConcurrencyTriggers.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFunctionsScaleAndConcurrency;
        });
    }
}

