/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.FlowAccessControlConfiguration;
import com.azure.resourcemanager.appservice.models.FlowEndpointsConfiguration;
import com.azure.resourcemanager.appservice.models.Kind;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowParameter;
import com.azure.resourcemanager.appservice.models.WorkflowProvisioningState;
import com.azure.resourcemanager.appservice.models.WorkflowSku;
import com.azure.resourcemanager.appservice.models.WorkflowState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class WorkflowProperties
implements JsonSerializable<WorkflowProperties> {
    private WorkflowProvisioningState provisioningState;
    private OffsetDateTime createdTime;
    private OffsetDateTime changedTime;
    private WorkflowState state;
    private String version;
    private String accessEndpoint;
    private FlowEndpointsConfiguration endpointsConfiguration;
    private FlowAccessControlConfiguration accessControl;
    private WorkflowSku sku;
    private ResourceReference integrationAccount;
    private ResourceReference integrationServiceEnvironment;
    private Object definition;
    private Map<String, WorkflowParameter> parameters;
    private Kind kind;

    public WorkflowProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime changedTime() {
        return this.changedTime;
    }

    public WorkflowState state() {
        return this.state;
    }

    public WorkflowProperties withState(WorkflowState state) {
        this.state = state;
        return this;
    }

    public String version() {
        return this.version;
    }

    public String accessEndpoint() {
        return this.accessEndpoint;
    }

    public FlowEndpointsConfiguration endpointsConfiguration() {
        return this.endpointsConfiguration;
    }

    public WorkflowProperties withEndpointsConfiguration(FlowEndpointsConfiguration endpointsConfiguration) {
        this.endpointsConfiguration = endpointsConfiguration;
        return this;
    }

    public FlowAccessControlConfiguration accessControl() {
        return this.accessControl;
    }

    public WorkflowProperties withAccessControl(FlowAccessControlConfiguration accessControl) {
        this.accessControl = accessControl;
        return this;
    }

    public WorkflowSku sku() {
        return this.sku;
    }

    public ResourceReference integrationAccount() {
        return this.integrationAccount;
    }

    public WorkflowProperties withIntegrationAccount(ResourceReference integrationAccount) {
        this.integrationAccount = integrationAccount;
        return this;
    }

    public ResourceReference integrationServiceEnvironment() {
        return this.integrationServiceEnvironment;
    }

    public WorkflowProperties withIntegrationServiceEnvironment(ResourceReference integrationServiceEnvironment) {
        this.integrationServiceEnvironment = integrationServiceEnvironment;
        return this;
    }

    public Object definition() {
        return this.definition;
    }

    public WorkflowProperties withDefinition(Object definition) {
        this.definition = definition;
        return this;
    }

    public Map<String, WorkflowParameter> parameters() {
        return this.parameters;
    }

    public WorkflowProperties withParameters(Map<String, WorkflowParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Kind kind() {
        return this.kind;
    }

    public WorkflowProperties withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    public void validate() {
        if (this.endpointsConfiguration() != null) {
            this.endpointsConfiguration().validate();
        }
        if (this.accessControl() != null) {
            this.accessControl().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.integrationAccount() != null) {
            this.integrationAccount().validate();
        }
        if (this.integrationServiceEnvironment() != null) {
            this.integrationServiceEnvironment().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("endpointsConfiguration", (JsonSerializable)this.endpointsConfiguration);
        jsonWriter.writeJsonField("accessControl", (JsonSerializable)this.accessControl);
        jsonWriter.writeJsonField("integrationAccount", (JsonSerializable)this.integrationAccount);
        jsonWriter.writeJsonField("integrationServiceEnvironment", (JsonSerializable)this.integrationServiceEnvironment);
        if (this.definition != null) {
            jsonWriter.writeUntypedField("definition", this.definition);
        }
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static WorkflowProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowProperties)jsonReader.readObject(reader -> {
            WorkflowProperties deserializedWorkflowProperties = new WorkflowProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedWorkflowProperties.provisioningState = WorkflowProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedWorkflowProperties.createdTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("changedTime".equals(fieldName)) {
                    deserializedWorkflowProperties.changedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedWorkflowProperties.state = WorkflowState.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedWorkflowProperties.version = reader.getString();
                    continue;
                }
                if ("accessEndpoint".equals(fieldName)) {
                    deserializedWorkflowProperties.accessEndpoint = reader.getString();
                    continue;
                }
                if ("endpointsConfiguration".equals(fieldName)) {
                    deserializedWorkflowProperties.endpointsConfiguration = FlowEndpointsConfiguration.fromJson(reader);
                    continue;
                }
                if ("accessControl".equals(fieldName)) {
                    deserializedWorkflowProperties.accessControl = FlowAccessControlConfiguration.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedWorkflowProperties.sku = WorkflowSku.fromJson(reader);
                    continue;
                }
                if ("integrationAccount".equals(fieldName)) {
                    deserializedWorkflowProperties.integrationAccount = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("integrationServiceEnvironment".equals(fieldName)) {
                    deserializedWorkflowProperties.integrationServiceEnvironment = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("definition".equals(fieldName)) {
                    deserializedWorkflowProperties.definition = reader.readUntyped();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedWorkflowProperties.parameters = parameters = reader.readMap(reader1 -> WorkflowParameter.fromJson(reader1));
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedWorkflowProperties.kind = Kind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowProperties;
        });
    }
}

