/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.RecurrenceFrequency;
import com.azure.resourcemanager.appservice.models.RecurrenceSchedule;
import java.io.IOException;

public final class WorkflowTriggerRecurrence
implements JsonSerializable<WorkflowTriggerRecurrence> {
    private RecurrenceFrequency frequency;
    private Integer interval;
    private String startTime;
    private String endTime;
    private String timeZone;
    private RecurrenceSchedule schedule;

    public RecurrenceFrequency frequency() {
        return this.frequency;
    }

    public WorkflowTriggerRecurrence withFrequency(RecurrenceFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public Integer interval() {
        return this.interval;
    }

    public WorkflowTriggerRecurrence withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    public String startTime() {
        return this.startTime;
    }

    public WorkflowTriggerRecurrence withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String endTime() {
        return this.endTime;
    }

    public WorkflowTriggerRecurrence withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public WorkflowTriggerRecurrence withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public RecurrenceSchedule schedule() {
        return this.schedule;
    }

    public WorkflowTriggerRecurrence withSchedule(RecurrenceSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public void validate() {
        if (this.schedule() != null) {
            this.schedule().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("frequency", this.frequency == null ? null : this.frequency.toString());
        jsonWriter.writeNumberField("interval", (Number)this.interval);
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeStringField("endTime", this.endTime);
        jsonWriter.writeStringField("timeZone", this.timeZone);
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowTriggerRecurrence fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowTriggerRecurrence)jsonReader.readObject(reader -> {
            WorkflowTriggerRecurrence deserializedWorkflowTriggerRecurrence = new WorkflowTriggerRecurrence();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("frequency".equals(fieldName)) {
                    deserializedWorkflowTriggerRecurrence.frequency = RecurrenceFrequency.fromString(reader.getString());
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedWorkflowTriggerRecurrence.interval = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedWorkflowTriggerRecurrence.startTime = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedWorkflowTriggerRecurrence.endTime = reader.getString();
                    continue;
                }
                if ("timeZone".equals(fieldName)) {
                    deserializedWorkflowTriggerRecurrence.timeZone = reader.getString();
                    continue;
                }
                if ("schedule".equals(fieldName)) {
                    deserializedWorkflowTriggerRecurrence.schedule = RecurrenceSchedule.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowTriggerRecurrence;
        });
    }
}

