/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowSkuName;
import java.io.IOException;

public final class WorkflowSku
implements JsonSerializable<WorkflowSku> {
    private WorkflowSkuName name;
    private ResourceReference plan;
    private static final ClientLogger LOGGER = new ClientLogger(WorkflowSku.class);

    public WorkflowSkuName name() {
        return this.name;
    }

    public WorkflowSku withName(WorkflowSkuName name) {
        this.name = name;
        return this;
    }

    public ResourceReference plan() {
        return this.plan;
    }

    public WorkflowSku withPlan(ResourceReference plan) {
        this.plan = plan;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model WorkflowSku"));
        }
        if (this.plan() != null) {
            this.plan().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeJsonField("plan", (JsonSerializable)this.plan);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowSku fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowSku)jsonReader.readObject(reader -> {
            WorkflowSku deserializedWorkflowSku = new WorkflowSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedWorkflowSku.name = WorkflowSkuName.fromString(reader.getString());
                    continue;
                }
                if ("plan".equals(fieldName)) {
                    deserializedWorkflowSku.plan = ResourceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowSku;
        });
    }
}

