/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WebAppStackInner;
import java.io.IOException;
import java.util.List;

public final class WebAppStackCollection
implements JsonSerializable<WebAppStackCollection> {
    private List<WebAppStackInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(WebAppStackCollection.class);

    public List<WebAppStackInner> value() {
        return this.value;
    }

    public WebAppStackCollection withValue(List<WebAppStackInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model WebAppStackCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WebAppStackCollection fromJson(JsonReader jsonReader) throws IOException {
        return (WebAppStackCollection)jsonReader.readObject(reader -> {
            WebAppStackCollection deserializedWebAppStackCollection = new WebAppStackCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedWebAppStackCollection.value = value = reader.readArray(reader1 -> WebAppStackInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedWebAppStackCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebAppStackCollection;
        });
    }
}

