/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.TwitterRegistration;
import java.io.IOException;

public final class Twitter
implements JsonSerializable<Twitter> {
    private Boolean enabled;
    private TwitterRegistration registration;

    public Boolean enabled() {
        return this.enabled;
    }

    public Twitter withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public TwitterRegistration registration() {
        return this.registration;
    }

    public Twitter withRegistration(TwitterRegistration registration) {
        this.registration = registration;
        return this;
    }

    public void validate() {
        if (this.registration() != null) {
            this.registration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("registration", (JsonSerializable)this.registration);
        return jsonWriter.writeEndObject();
    }

    public static Twitter fromJson(JsonReader jsonReader) throws IOException {
        return (Twitter)jsonReader.readObject(reader -> {
            Twitter deserializedTwitter = new Twitter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedTwitter.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("registration".equals(fieldName)) {
                    deserializedTwitter.registration = TwitterRegistration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTwitter;
        });
    }
}

