/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.OpenAuthenticationAccessPolicy;
import java.io.IOException;
import java.util.Map;

public final class OpenAuthenticationAccessPolicies
implements JsonSerializable<OpenAuthenticationAccessPolicies> {
    private Map<String, OpenAuthenticationAccessPolicy> policies;

    public Map<String, OpenAuthenticationAccessPolicy> policies() {
        return this.policies;
    }

    public OpenAuthenticationAccessPolicies withPolicies(Map<String, OpenAuthenticationAccessPolicy> policies) {
        this.policies = policies;
        return this;
    }

    public void validate() {
        if (this.policies() != null) {
            this.policies().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("policies", this.policies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OpenAuthenticationAccessPolicies fromJson(JsonReader jsonReader) throws IOException {
        return (OpenAuthenticationAccessPolicies)jsonReader.readObject(reader -> {
            OpenAuthenticationAccessPolicies deserializedOpenAuthenticationAccessPolicies = new OpenAuthenticationAccessPolicies();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policies".equals(fieldName)) {
                    Map policies;
                    deserializedOpenAuthenticationAccessPolicies.policies = policies = reader.readMap(reader1 -> OpenAuthenticationAccessPolicy.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenAuthenticationAccessPolicies;
        });
    }
}

