/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.IpFilterTag;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class IpSecurityRestriction
implements JsonSerializable<IpSecurityRestriction> {
    private String ipAddress;
    private String subnetMask;
    private String vnetSubnetResourceId;
    private Integer vnetTrafficTag;
    private Integer subnetTrafficTag;
    private String action;
    private IpFilterTag tag;
    private Integer priority;
    private String name;
    private String description;
    private Map<String, List<String>> headers;

    public String ipAddress() {
        return this.ipAddress;
    }

    public IpSecurityRestriction withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public String subnetMask() {
        return this.subnetMask;
    }

    public IpSecurityRestriction withSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
        return this;
    }

    public String vnetSubnetResourceId() {
        return this.vnetSubnetResourceId;
    }

    public IpSecurityRestriction withVnetSubnetResourceId(String vnetSubnetResourceId) {
        this.vnetSubnetResourceId = vnetSubnetResourceId;
        return this;
    }

    public Integer vnetTrafficTag() {
        return this.vnetTrafficTag;
    }

    public IpSecurityRestriction withVnetTrafficTag(Integer vnetTrafficTag) {
        this.vnetTrafficTag = vnetTrafficTag;
        return this;
    }

    public Integer subnetTrafficTag() {
        return this.subnetTrafficTag;
    }

    public IpSecurityRestriction withSubnetTrafficTag(Integer subnetTrafficTag) {
        this.subnetTrafficTag = subnetTrafficTag;
        return this;
    }

    public String action() {
        return this.action;
    }

    public IpSecurityRestriction withAction(String action) {
        this.action = action;
        return this;
    }

    public IpFilterTag tag() {
        return this.tag;
    }

    public IpSecurityRestriction withTag(IpFilterTag tag) {
        this.tag = tag;
        return this;
    }

    public Integer priority() {
        return this.priority;
    }

    public IpSecurityRestriction withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public String name() {
        return this.name;
    }

    public IpSecurityRestriction withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public IpSecurityRestriction withDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public IpSecurityRestriction withHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeStringField("subnetMask", this.subnetMask);
        jsonWriter.writeStringField("vnetSubnetResourceId", this.vnetSubnetResourceId);
        jsonWriter.writeNumberField("vnetTrafficTag", (Number)this.vnetTrafficTag);
        jsonWriter.writeNumberField("subnetTrafficTag", (Number)this.subnetTrafficTag);
        jsonWriter.writeStringField("action", this.action);
        jsonWriter.writeStringField("tag", this.tag == null ? null : this.tag.toString());
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("headers", this.headers, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeString(element1)));
        return jsonWriter.writeEndObject();
    }

    public static IpSecurityRestriction fromJson(JsonReader jsonReader) throws IOException {
        return (IpSecurityRestriction)jsonReader.readObject(reader -> {
            IpSecurityRestriction deserializedIpSecurityRestriction = new IpSecurityRestriction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ipAddress".equals(fieldName)) {
                    deserializedIpSecurityRestriction.ipAddress = reader.getString();
                    continue;
                }
                if ("subnetMask".equals(fieldName)) {
                    deserializedIpSecurityRestriction.subnetMask = reader.getString();
                    continue;
                }
                if ("vnetSubnetResourceId".equals(fieldName)) {
                    deserializedIpSecurityRestriction.vnetSubnetResourceId = reader.getString();
                    continue;
                }
                if ("vnetTrafficTag".equals(fieldName)) {
                    deserializedIpSecurityRestriction.vnetTrafficTag = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("subnetTrafficTag".equals(fieldName)) {
                    deserializedIpSecurityRestriction.subnetTrafficTag = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedIpSecurityRestriction.action = reader.getString();
                    continue;
                }
                if ("tag".equals(fieldName)) {
                    deserializedIpSecurityRestriction.tag = IpFilterTag.fromString(reader.getString());
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedIpSecurityRestriction.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIpSecurityRestriction.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedIpSecurityRestriction.description = reader.getString();
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    Map headers;
                    deserializedIpSecurityRestriction.headers = headers = reader.readMap(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpSecurityRestriction;
        });
    }
}

