/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.IdentifierInner;
import java.io.IOException;
import java.util.List;

public final class IdentifierCollection
implements JsonSerializable<IdentifierCollection> {
    private List<IdentifierInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(IdentifierCollection.class);

    public List<IdentifierInner> value() {
        return this.value;
    }

    public IdentifierCollection withValue(List<IdentifierInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model IdentifierCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static IdentifierCollection fromJson(JsonReader jsonReader) throws IOException {
        return (IdentifierCollection)jsonReader.readObject(reader -> {
            IdentifierCollection deserializedIdentifierCollection = new IdentifierCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedIdentifierCollection.value = value = reader.readArray(reader1 -> IdentifierInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedIdentifierCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentifierCollection;
        });
    }
}

