/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.IpAddress;
import java.io.IOException;
import java.util.List;

public final class FlowEndpoints
implements JsonSerializable<FlowEndpoints> {
    private List<IpAddress> outgoingIpAddresses;
    private List<IpAddress> accessEndpointIpAddresses;

    public List<IpAddress> outgoingIpAddresses() {
        return this.outgoingIpAddresses;
    }

    public FlowEndpoints withOutgoingIpAddresses(List<IpAddress> outgoingIpAddresses) {
        this.outgoingIpAddresses = outgoingIpAddresses;
        return this;
    }

    public List<IpAddress> accessEndpointIpAddresses() {
        return this.accessEndpointIpAddresses;
    }

    public FlowEndpoints withAccessEndpointIpAddresses(List<IpAddress> accessEndpointIpAddresses) {
        this.accessEndpointIpAddresses = accessEndpointIpAddresses;
        return this;
    }

    public void validate() {
        if (this.outgoingIpAddresses() != null) {
            this.outgoingIpAddresses().forEach(e -> e.validate());
        }
        if (this.accessEndpointIpAddresses() != null) {
            this.accessEndpointIpAddresses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("outgoingIpAddresses", this.outgoingIpAddresses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("accessEndpointIpAddresses", this.accessEndpointIpAddresses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FlowEndpoints fromJson(JsonReader jsonReader) throws IOException {
        return (FlowEndpoints)jsonReader.readObject(reader -> {
            FlowEndpoints deserializedFlowEndpoints = new FlowEndpoints();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("outgoingIpAddresses".equals(fieldName)) {
                    List outgoingIpAddresses;
                    deserializedFlowEndpoints.outgoingIpAddresses = outgoingIpAddresses = reader.readArray(reader1 -> IpAddress.fromJson(reader1));
                    continue;
                }
                if ("accessEndpointIpAddresses".equals(fieldName)) {
                    List accessEndpointIpAddresses;
                    deserializedFlowEndpoints.accessEndpointIpAddresses = accessEndpointIpAddresses = reader.readArray(reader1 -> IpAddress.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFlowEndpoints;
        });
    }
}

