/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.IssueType;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.Solution;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class DetectorAbnormalTimePeriod
implements JsonSerializable<DetectorAbnormalTimePeriod> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String message;
    private String source;
    private Double priority;
    private List<List<NameValuePair>> metadata;
    private IssueType type;
    private List<Solution> solutions;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public DetectorAbnormalTimePeriod withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public DetectorAbnormalTimePeriod withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public String message() {
        return this.message;
    }

    public DetectorAbnormalTimePeriod withMessage(String message) {
        this.message = message;
        return this;
    }

    public String source() {
        return this.source;
    }

    public DetectorAbnormalTimePeriod withSource(String source) {
        this.source = source;
        return this;
    }

    public Double priority() {
        return this.priority;
    }

    public DetectorAbnormalTimePeriod withPriority(Double priority) {
        this.priority = priority;
        return this;
    }

    public List<List<NameValuePair>> metadata() {
        return this.metadata;
    }

    public DetectorAbnormalTimePeriod withMetadata(List<List<NameValuePair>> metadata) {
        this.metadata = metadata;
        return this;
    }

    public IssueType type() {
        return this.type;
    }

    public DetectorAbnormalTimePeriod withType(IssueType type) {
        this.type = type;
        return this;
    }

    public List<Solution> solutions() {
        return this.solutions;
    }

    public DetectorAbnormalTimePeriod withSolutions(List<Solution> solutions) {
        this.solutions = solutions;
        return this;
    }

    public void validate() {
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
        if (this.solutions() != null) {
            this.solutions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeArrayField("metaData", this.metadata, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeJson((JsonSerializable)element1)));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("solutions", this.solutions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DetectorAbnormalTimePeriod fromJson(JsonReader jsonReader) throws IOException {
        return (DetectorAbnormalTimePeriod)jsonReader.readObject(reader -> {
            DetectorAbnormalTimePeriod deserializedDetectorAbnormalTimePeriod = new DetectorAbnormalTimePeriod();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedDetectorAbnormalTimePeriod.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedDetectorAbnormalTimePeriod.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedDetectorAbnormalTimePeriod.message = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedDetectorAbnormalTimePeriod.source = reader.getString();
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedDetectorAbnormalTimePeriod.priority = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("metaData".equals(fieldName)) {
                    List metadata;
                    deserializedDetectorAbnormalTimePeriod.metadata = metadata = reader.readArray(reader1 -> reader1.readArray(reader2 -> NameValuePair.fromJson(reader2)));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDetectorAbnormalTimePeriod.type = IssueType.fromString(reader.getString());
                    continue;
                }
                if ("solutions".equals(fieldName)) {
                    List solutions;
                    deserializedDetectorAbnormalTimePeriod.solutions = solutions = reader.readArray(reader1 -> Solution.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDetectorAbnormalTimePeriod;
        });
    }
}

