/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.CsmOperationDescriptionInner;
import java.io.IOException;
import java.util.List;

public final class CsmOperationCollection
implements JsonSerializable<CsmOperationCollection> {
    private List<CsmOperationDescriptionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(CsmOperationCollection.class);

    public List<CsmOperationDescriptionInner> value() {
        return this.value;
    }

    public CsmOperationCollection withValue(List<CsmOperationDescriptionInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model CsmOperationCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CsmOperationCollection fromJson(JsonReader jsonReader) throws IOException {
        return (CsmOperationCollection)jsonReader.readObject(reader -> {
            CsmOperationCollection deserializedCsmOperationCollection = new CsmOperationCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedCsmOperationCollection.value = value = reader.readArray(reader1 -> CsmOperationDescriptionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedCsmOperationCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCsmOperationCollection;
        });
    }
}

