/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.ContinuousWebJobInner;
import java.io.IOException;
import java.util.List;

public final class ContinuousWebJobCollection
implements JsonSerializable<ContinuousWebJobCollection> {
    private List<ContinuousWebJobInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ContinuousWebJobCollection.class);

    public List<ContinuousWebJobInner> value() {
        return this.value;
    }

    public ContinuousWebJobCollection withValue(List<ContinuousWebJobInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ContinuousWebJobCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ContinuousWebJobCollection fromJson(JsonReader jsonReader) throws IOException {
        return (ContinuousWebJobCollection)jsonReader.readObject(reader -> {
            ContinuousWebJobCollection deserializedContinuousWebJobCollection = new ContinuousWebJobCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedContinuousWebJobCollection.value = value = reader.readArray(reader1 -> ContinuousWebJobInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedContinuousWebJobCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContinuousWebJobCollection;
        });
    }
}

