/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WorkflowVersionProperties;
import com.azure.resourcemanager.appservice.models.FlowAccessControlConfiguration;
import com.azure.resourcemanager.appservice.models.FlowEndpointsConfiguration;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowParameter;
import com.azure.resourcemanager.appservice.models.WorkflowProvisioningState;
import com.azure.resourcemanager.appservice.models.WorkflowResource;
import com.azure.resourcemanager.appservice.models.WorkflowSku;
import com.azure.resourcemanager.appservice.models.WorkflowState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class WorkflowVersionInner
extends WorkflowResource {
    private WorkflowVersionProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private WorkflowVersionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public WorkflowVersionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public WorkflowVersionInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public WorkflowProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    public OffsetDateTime changedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().changedTime();
    }

    public WorkflowState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public WorkflowVersionInner withState(WorkflowState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowVersionProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public String accessEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().accessEndpoint();
    }

    public FlowEndpointsConfiguration endpointsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointsConfiguration();
    }

    public WorkflowVersionInner withEndpointsConfiguration(FlowEndpointsConfiguration endpointsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowVersionProperties();
        }
        this.innerProperties().withEndpointsConfiguration(endpointsConfiguration);
        return this;
    }

    public FlowAccessControlConfiguration accessControl() {
        return this.innerProperties() == null ? null : this.innerProperties().accessControl();
    }

    public WorkflowVersionInner withAccessControl(FlowAccessControlConfiguration accessControl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowVersionProperties();
        }
        this.innerProperties().withAccessControl(accessControl);
        return this;
    }

    public WorkflowSku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public ResourceReference integrationAccount() {
        return this.innerProperties() == null ? null : this.innerProperties().integrationAccount();
    }

    public WorkflowVersionInner withIntegrationAccount(ResourceReference integrationAccount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowVersionProperties();
        }
        this.innerProperties().withIntegrationAccount(integrationAccount);
        return this;
    }

    public Object definition() {
        return this.innerProperties() == null ? null : this.innerProperties().definition();
    }

    public WorkflowVersionInner withDefinition(Object definition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowVersionProperties();
        }
        this.innerProperties().withDefinition(definition);
        return this;
    }

    public Map<String, WorkflowParameter> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public WorkflowVersionInner withParameters(Map<String, WorkflowParameter> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowVersionProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowVersionInner fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowVersionInner)((Object)jsonReader.readObject(reader -> {
            WorkflowVersionInner deserializedWorkflowVersionInner = new WorkflowVersionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkflowVersionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkflowVersionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkflowVersionInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWorkflowVersionInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedWorkflowVersionInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkflowVersionInner.innerProperties = WorkflowVersionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowVersionInner;
        }));
    }
}

