/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.GitHubActionConfiguration;
import java.io.IOException;

public final class SiteSourceControlProperties
implements JsonSerializable<SiteSourceControlProperties> {
    private String repoUrl;
    private String branch;
    private Boolean isManualIntegration;
    private Boolean isGitHubAction;
    private Boolean deploymentRollbackEnabled;
    private Boolean isMercurial;
    private GitHubActionConfiguration gitHubActionConfiguration;

    public String repoUrl() {
        return this.repoUrl;
    }

    public SiteSourceControlProperties withRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public SiteSourceControlProperties withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public Boolean isManualIntegration() {
        return this.isManualIntegration;
    }

    public SiteSourceControlProperties withIsManualIntegration(Boolean isManualIntegration) {
        this.isManualIntegration = isManualIntegration;
        return this;
    }

    public Boolean isGitHubAction() {
        return this.isGitHubAction;
    }

    public SiteSourceControlProperties withIsGitHubAction(Boolean isGitHubAction) {
        this.isGitHubAction = isGitHubAction;
        return this;
    }

    public Boolean deploymentRollbackEnabled() {
        return this.deploymentRollbackEnabled;
    }

    public SiteSourceControlProperties withDeploymentRollbackEnabled(Boolean deploymentRollbackEnabled) {
        this.deploymentRollbackEnabled = deploymentRollbackEnabled;
        return this;
    }

    public Boolean isMercurial() {
        return this.isMercurial;
    }

    public SiteSourceControlProperties withIsMercurial(Boolean isMercurial) {
        this.isMercurial = isMercurial;
        return this;
    }

    public GitHubActionConfiguration gitHubActionConfiguration() {
        return this.gitHubActionConfiguration;
    }

    public SiteSourceControlProperties withGitHubActionConfiguration(GitHubActionConfiguration gitHubActionConfiguration) {
        this.gitHubActionConfiguration = gitHubActionConfiguration;
        return this;
    }

    public void validate() {
        if (this.gitHubActionConfiguration() != null) {
            this.gitHubActionConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("repoUrl", this.repoUrl);
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeBooleanField("isManualIntegration", this.isManualIntegration);
        jsonWriter.writeBooleanField("isGitHubAction", this.isGitHubAction);
        jsonWriter.writeBooleanField("deploymentRollbackEnabled", this.deploymentRollbackEnabled);
        jsonWriter.writeBooleanField("isMercurial", this.isMercurial);
        jsonWriter.writeJsonField("gitHubActionConfiguration", (JsonSerializable)this.gitHubActionConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static SiteSourceControlProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SiteSourceControlProperties)jsonReader.readObject(reader -> {
            SiteSourceControlProperties deserializedSiteSourceControlProperties = new SiteSourceControlProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("repoUrl".equals(fieldName)) {
                    deserializedSiteSourceControlProperties.repoUrl = reader.getString();
                    continue;
                }
                if ("branch".equals(fieldName)) {
                    deserializedSiteSourceControlProperties.branch = reader.getString();
                    continue;
                }
                if ("isManualIntegration".equals(fieldName)) {
                    deserializedSiteSourceControlProperties.isManualIntegration = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isGitHubAction".equals(fieldName)) {
                    deserializedSiteSourceControlProperties.isGitHubAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("deploymentRollbackEnabled".equals(fieldName)) {
                    deserializedSiteSourceControlProperties.deploymentRollbackEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isMercurial".equals(fieldName)) {
                    deserializedSiteSourceControlProperties.isMercurial = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("gitHubActionConfiguration".equals(fieldName)) {
                    deserializedSiteSourceControlProperties.gitHubActionConfiguration = GitHubActionConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteSourceControlProperties;
        });
    }
}

