/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigInner;
import com.azure.resourcemanager.appservice.models.ClientCertMode;
import com.azure.resourcemanager.appservice.models.CloningInfo;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.HostnameSslState;
import com.azure.resourcemanager.appservice.models.RedundancyMode;
import com.azure.resourcemanager.appservice.models.SiteAvailabilityState;
import com.azure.resourcemanager.appservice.models.SiteDnsConfig;
import com.azure.resourcemanager.appservice.models.SlotSwapStatus;
import com.azure.resourcemanager.appservice.models.UsageState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;

public final class SitePatchResourcePropertiesInner
implements JsonSerializable<SitePatchResourcePropertiesInner> {
    private String state;
    private List<String> hostNames;
    private String repositorySiteName;
    private UsageState usageState;
    private Boolean enabled;
    private List<String> enabledHostNames;
    private SiteAvailabilityState availabilityState;
    private List<HostnameSslState> hostnameSslStates;
    private String serverFarmId;
    private Boolean reserved;
    private Boolean isXenon;
    private Boolean hyperV;
    private OffsetDateTime lastModifiedTimeUtc;
    private SiteDnsConfig dnsConfiguration;
    private SiteConfigInner siteConfig;
    private List<String> trafficManagerHostNames;
    private Boolean scmSiteAlsoStopped;
    private String targetSwapSlot;
    private HostingEnvironmentProfile hostingEnvironmentProfile;
    private Boolean clientAffinityEnabled;
    private Boolean clientCertEnabled;
    private ClientCertMode clientCertMode;
    private String clientCertExclusionPaths;
    private Boolean hostNamesDisabled;
    private String customDomainVerificationId;
    private String outboundIpAddresses;
    private String possibleOutboundIpAddresses;
    private Integer containerSize;
    private Integer dailyMemoryTimeQuota;
    private OffsetDateTime suspendedTill;
    private Integer maxNumberOfWorkers;
    private CloningInfo cloningInfo;
    private String resourceGroup;
    private Boolean isDefaultContainer;
    private String defaultHostname;
    private SlotSwapStatus slotSwapStatus;
    private Boolean httpsOnly;
    private RedundancyMode redundancyMode;
    private UUID inProgressOperationId;
    private Boolean storageAccountRequired;
    private String keyVaultReferenceIdentity;
    private String virtualNetworkSubnetId;

    public String state() {
        return this.state;
    }

    public List<String> hostNames() {
        return this.hostNames;
    }

    public String repositorySiteName() {
        return this.repositorySiteName;
    }

    public UsageState usageState() {
        return this.usageState;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public SitePatchResourcePropertiesInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> enabledHostNames() {
        return this.enabledHostNames;
    }

    public SiteAvailabilityState availabilityState() {
        return this.availabilityState;
    }

    public List<HostnameSslState> hostnameSslStates() {
        return this.hostnameSslStates;
    }

    public SitePatchResourcePropertiesInner withHostnameSslStates(List<HostnameSslState> hostnameSslStates) {
        this.hostnameSslStates = hostnameSslStates;
        return this;
    }

    public String serverFarmId() {
        return this.serverFarmId;
    }

    public SitePatchResourcePropertiesInner withServerFarmId(String serverFarmId) {
        this.serverFarmId = serverFarmId;
        return this;
    }

    public Boolean reserved() {
        return this.reserved;
    }

    public SitePatchResourcePropertiesInner withReserved(Boolean reserved) {
        this.reserved = reserved;
        return this;
    }

    public Boolean isXenon() {
        return this.isXenon;
    }

    public SitePatchResourcePropertiesInner withIsXenon(Boolean isXenon) {
        this.isXenon = isXenon;
        return this;
    }

    public Boolean hyperV() {
        return this.hyperV;
    }

    public SitePatchResourcePropertiesInner withHyperV(Boolean hyperV) {
        this.hyperV = hyperV;
        return this;
    }

    public OffsetDateTime lastModifiedTimeUtc() {
        return this.lastModifiedTimeUtc;
    }

    public SiteDnsConfig dnsConfiguration() {
        return this.dnsConfiguration;
    }

    public SitePatchResourcePropertiesInner withDnsConfiguration(SiteDnsConfig dnsConfiguration) {
        this.dnsConfiguration = dnsConfiguration;
        return this;
    }

    public SiteConfigInner siteConfig() {
        return this.siteConfig;
    }

    public SitePatchResourcePropertiesInner withSiteConfig(SiteConfigInner siteConfig) {
        this.siteConfig = siteConfig;
        return this;
    }

    public List<String> trafficManagerHostNames() {
        return this.trafficManagerHostNames;
    }

    public Boolean scmSiteAlsoStopped() {
        return this.scmSiteAlsoStopped;
    }

    public SitePatchResourcePropertiesInner withScmSiteAlsoStopped(Boolean scmSiteAlsoStopped) {
        this.scmSiteAlsoStopped = scmSiteAlsoStopped;
        return this;
    }

    public String targetSwapSlot() {
        return this.targetSwapSlot;
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.hostingEnvironmentProfile;
    }

    public SitePatchResourcePropertiesInner withHostingEnvironmentProfile(HostingEnvironmentProfile hostingEnvironmentProfile) {
        this.hostingEnvironmentProfile = hostingEnvironmentProfile;
        return this;
    }

    public Boolean clientAffinityEnabled() {
        return this.clientAffinityEnabled;
    }

    public SitePatchResourcePropertiesInner withClientAffinityEnabled(Boolean clientAffinityEnabled) {
        this.clientAffinityEnabled = clientAffinityEnabled;
        return this;
    }

    public Boolean clientCertEnabled() {
        return this.clientCertEnabled;
    }

    public SitePatchResourcePropertiesInner withClientCertEnabled(Boolean clientCertEnabled) {
        this.clientCertEnabled = clientCertEnabled;
        return this;
    }

    public ClientCertMode clientCertMode() {
        return this.clientCertMode;
    }

    public SitePatchResourcePropertiesInner withClientCertMode(ClientCertMode clientCertMode) {
        this.clientCertMode = clientCertMode;
        return this;
    }

    public String clientCertExclusionPaths() {
        return this.clientCertExclusionPaths;
    }

    public SitePatchResourcePropertiesInner withClientCertExclusionPaths(String clientCertExclusionPaths) {
        this.clientCertExclusionPaths = clientCertExclusionPaths;
        return this;
    }

    public Boolean hostNamesDisabled() {
        return this.hostNamesDisabled;
    }

    public SitePatchResourcePropertiesInner withHostNamesDisabled(Boolean hostNamesDisabled) {
        this.hostNamesDisabled = hostNamesDisabled;
        return this;
    }

    public String customDomainVerificationId() {
        return this.customDomainVerificationId;
    }

    public SitePatchResourcePropertiesInner withCustomDomainVerificationId(String customDomainVerificationId) {
        this.customDomainVerificationId = customDomainVerificationId;
        return this;
    }

    public String outboundIpAddresses() {
        return this.outboundIpAddresses;
    }

    public String possibleOutboundIpAddresses() {
        return this.possibleOutboundIpAddresses;
    }

    public Integer containerSize() {
        return this.containerSize;
    }

    public SitePatchResourcePropertiesInner withContainerSize(Integer containerSize) {
        this.containerSize = containerSize;
        return this;
    }

    public Integer dailyMemoryTimeQuota() {
        return this.dailyMemoryTimeQuota;
    }

    public SitePatchResourcePropertiesInner withDailyMemoryTimeQuota(Integer dailyMemoryTimeQuota) {
        this.dailyMemoryTimeQuota = dailyMemoryTimeQuota;
        return this;
    }

    public OffsetDateTime suspendedTill() {
        return this.suspendedTill;
    }

    public Integer maxNumberOfWorkers() {
        return this.maxNumberOfWorkers;
    }

    public CloningInfo cloningInfo() {
        return this.cloningInfo;
    }

    public SitePatchResourcePropertiesInner withCloningInfo(CloningInfo cloningInfo) {
        this.cloningInfo = cloningInfo;
        return this;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public Boolean isDefaultContainer() {
        return this.isDefaultContainer;
    }

    public String defaultHostname() {
        return this.defaultHostname;
    }

    public SlotSwapStatus slotSwapStatus() {
        return this.slotSwapStatus;
    }

    public Boolean httpsOnly() {
        return this.httpsOnly;
    }

    public SitePatchResourcePropertiesInner withHttpsOnly(Boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    public RedundancyMode redundancyMode() {
        return this.redundancyMode;
    }

    public SitePatchResourcePropertiesInner withRedundancyMode(RedundancyMode redundancyMode) {
        this.redundancyMode = redundancyMode;
        return this;
    }

    public UUID inProgressOperationId() {
        return this.inProgressOperationId;
    }

    public Boolean storageAccountRequired() {
        return this.storageAccountRequired;
    }

    public SitePatchResourcePropertiesInner withStorageAccountRequired(Boolean storageAccountRequired) {
        this.storageAccountRequired = storageAccountRequired;
        return this;
    }

    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    public SitePatchResourcePropertiesInner withKeyVaultReferenceIdentity(String keyVaultReferenceIdentity) {
        this.keyVaultReferenceIdentity = keyVaultReferenceIdentity;
        return this;
    }

    public String virtualNetworkSubnetId() {
        return this.virtualNetworkSubnetId;
    }

    public SitePatchResourcePropertiesInner withVirtualNetworkSubnetId(String virtualNetworkSubnetId) {
        this.virtualNetworkSubnetId = virtualNetworkSubnetId;
        return this;
    }

    public void validate() {
        if (this.hostnameSslStates() != null) {
            this.hostnameSslStates().forEach(e -> e.validate());
        }
        if (this.dnsConfiguration() != null) {
            this.dnsConfiguration().validate();
        }
        if (this.siteConfig() != null) {
            this.siteConfig().validate();
        }
        if (this.hostingEnvironmentProfile() != null) {
            this.hostingEnvironmentProfile().validate();
        }
        if (this.cloningInfo() != null) {
            this.cloningInfo().validate();
        }
        if (this.slotSwapStatus() != null) {
            this.slotSwapStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("hostNameSslStates", this.hostnameSslStates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("serverFarmId", this.serverFarmId);
        jsonWriter.writeBooleanField("reserved", this.reserved);
        jsonWriter.writeBooleanField("isXenon", this.isXenon);
        jsonWriter.writeBooleanField("hyperV", this.hyperV);
        jsonWriter.writeJsonField("dnsConfiguration", (JsonSerializable)this.dnsConfiguration);
        jsonWriter.writeJsonField("siteConfig", (JsonSerializable)this.siteConfig);
        jsonWriter.writeBooleanField("scmSiteAlsoStopped", this.scmSiteAlsoStopped);
        jsonWriter.writeJsonField("hostingEnvironmentProfile", (JsonSerializable)this.hostingEnvironmentProfile);
        jsonWriter.writeBooleanField("clientAffinityEnabled", this.clientAffinityEnabled);
        jsonWriter.writeBooleanField("clientCertEnabled", this.clientCertEnabled);
        jsonWriter.writeStringField("clientCertMode", this.clientCertMode == null ? null : this.clientCertMode.toString());
        jsonWriter.writeStringField("clientCertExclusionPaths", this.clientCertExclusionPaths);
        jsonWriter.writeBooleanField("hostNamesDisabled", this.hostNamesDisabled);
        jsonWriter.writeStringField("customDomainVerificationId", this.customDomainVerificationId);
        jsonWriter.writeNumberField("containerSize", (Number)this.containerSize);
        jsonWriter.writeNumberField("dailyMemoryTimeQuota", (Number)this.dailyMemoryTimeQuota);
        jsonWriter.writeJsonField("cloningInfo", (JsonSerializable)this.cloningInfo);
        jsonWriter.writeBooleanField("httpsOnly", this.httpsOnly);
        jsonWriter.writeStringField("redundancyMode", this.redundancyMode == null ? null : this.redundancyMode.toString());
        jsonWriter.writeBooleanField("storageAccountRequired", this.storageAccountRequired);
        jsonWriter.writeStringField("keyVaultReferenceIdentity", this.keyVaultReferenceIdentity);
        jsonWriter.writeStringField("virtualNetworkSubnetId", this.virtualNetworkSubnetId);
        return jsonWriter.writeEndObject();
    }

    public static SitePatchResourcePropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (SitePatchResourcePropertiesInner)jsonReader.readObject(reader -> {
            SitePatchResourcePropertiesInner deserializedSitePatchResourcePropertiesInner = new SitePatchResourcePropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.state = reader.getString();
                    continue;
                }
                if ("hostNames".equals(fieldName)) {
                    List hostNames;
                    deserializedSitePatchResourcePropertiesInner.hostNames = hostNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("repositorySiteName".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.repositorySiteName = reader.getString();
                    continue;
                }
                if ("usageState".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.usageState = UsageState.fromString(reader.getString());
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enabledHostNames".equals(fieldName)) {
                    List enabledHostNames;
                    deserializedSitePatchResourcePropertiesInner.enabledHostNames = enabledHostNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("availabilityState".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.availabilityState = SiteAvailabilityState.fromString(reader.getString());
                    continue;
                }
                if ("hostNameSslStates".equals(fieldName)) {
                    List hostnameSslStates;
                    deserializedSitePatchResourcePropertiesInner.hostnameSslStates = hostnameSslStates = reader.readArray(reader1 -> HostnameSslState.fromJson(reader1));
                    continue;
                }
                if ("serverFarmId".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.serverFarmId = reader.getString();
                    continue;
                }
                if ("reserved".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.reserved = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isXenon".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.isXenon = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hyperV".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.hyperV = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastModifiedTimeUtc".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.lastModifiedTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("dnsConfiguration".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.dnsConfiguration = SiteDnsConfig.fromJson(reader);
                    continue;
                }
                if ("siteConfig".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.siteConfig = SiteConfigInner.fromJson(reader);
                    continue;
                }
                if ("trafficManagerHostNames".equals(fieldName)) {
                    List trafficManagerHostNames;
                    deserializedSitePatchResourcePropertiesInner.trafficManagerHostNames = trafficManagerHostNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("scmSiteAlsoStopped".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.scmSiteAlsoStopped = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("targetSwapSlot".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.targetSwapSlot = reader.getString();
                    continue;
                }
                if ("hostingEnvironmentProfile".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.hostingEnvironmentProfile = HostingEnvironmentProfile.fromJson(reader);
                    continue;
                }
                if ("clientAffinityEnabled".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.clientAffinityEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("clientCertEnabled".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.clientCertEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("clientCertMode".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.clientCertMode = ClientCertMode.fromString(reader.getString());
                    continue;
                }
                if ("clientCertExclusionPaths".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.clientCertExclusionPaths = reader.getString();
                    continue;
                }
                if ("hostNamesDisabled".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.hostNamesDisabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customDomainVerificationId".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.customDomainVerificationId = reader.getString();
                    continue;
                }
                if ("outboundIpAddresses".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.outboundIpAddresses = reader.getString();
                    continue;
                }
                if ("possibleOutboundIpAddresses".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.possibleOutboundIpAddresses = reader.getString();
                    continue;
                }
                if ("containerSize".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.containerSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dailyMemoryTimeQuota".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.dailyMemoryTimeQuota = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("suspendedTill".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.suspendedTill = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("maxNumberOfWorkers".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.maxNumberOfWorkers = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cloningInfo".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.cloningInfo = CloningInfo.fromJson(reader);
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.resourceGroup = reader.getString();
                    continue;
                }
                if ("isDefaultContainer".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.isDefaultContainer = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultHostName".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.defaultHostname = reader.getString();
                    continue;
                }
                if ("slotSwapStatus".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.slotSwapStatus = SlotSwapStatus.fromJson(reader);
                    continue;
                }
                if ("httpsOnly".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.httpsOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("redundancyMode".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.redundancyMode = RedundancyMode.fromString(reader.getString());
                    continue;
                }
                if ("inProgressOperationId".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.inProgressOperationId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("storageAccountRequired".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.storageAccountRequired = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("keyVaultReferenceIdentity".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.keyVaultReferenceIdentity = reader.getString();
                    continue;
                }
                if ("virtualNetworkSubnetId".equals(fieldName)) {
                    deserializedSitePatchResourcePropertiesInner.virtualNetworkSubnetId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSitePatchResourcePropertiesInner;
        });
    }
}

