/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigProperties;
import com.azure.resourcemanager.appservice.models.ApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.EnabledConfig;
import com.azure.resourcemanager.appservice.models.HttpLogsConfig;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class SiteLogsConfigInner
extends ProxyOnlyResource {
    private SiteLogsConfigProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private SiteLogsConfigProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public SiteLogsConfigInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public ApplicationLogsConfig applicationLogs() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationLogs();
    }

    public SiteLogsConfigInner withApplicationLogs(ApplicationLogsConfig applicationLogs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteLogsConfigProperties();
        }
        this.innerProperties().withApplicationLogs(applicationLogs);
        return this;
    }

    public HttpLogsConfig httpLogs() {
        return this.innerProperties() == null ? null : this.innerProperties().httpLogs();
    }

    public SiteLogsConfigInner withHttpLogs(HttpLogsConfig httpLogs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteLogsConfigProperties();
        }
        this.innerProperties().withHttpLogs(httpLogs);
        return this;
    }

    public EnabledConfig failedRequestsTracing() {
        return this.innerProperties() == null ? null : this.innerProperties().failedRequestsTracing();
    }

    public SiteLogsConfigInner withFailedRequestsTracing(EnabledConfig failedRequestsTracing) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteLogsConfigProperties();
        }
        this.innerProperties().withFailedRequestsTracing(failedRequestsTracing);
        return this;
    }

    public EnabledConfig detailedErrorMessages() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedErrorMessages();
    }

    public SiteLogsConfigInner withDetailedErrorMessages(EnabledConfig detailedErrorMessages) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteLogsConfigProperties();
        }
        this.innerProperties().withDetailedErrorMessages(detailedErrorMessages);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SiteLogsConfigInner fromJson(JsonReader jsonReader) throws IOException {
        return (SiteLogsConfigInner)((Object)jsonReader.readObject(reader -> {
            SiteLogsConfigInner deserializedSiteLogsConfigInner = new SiteLogsConfigInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSiteLogsConfigInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSiteLogsConfigInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSiteLogsConfigInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedSiteLogsConfigInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSiteLogsConfigInner.innerProperties = SiteLogsConfigProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteLogsConfigInner;
        }));
    }
}

