/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.RecommendationRuleProperties;
import com.azure.resourcemanager.appservice.models.Channels;
import com.azure.resourcemanager.appservice.models.NotificationLevel;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

public final class RecommendationRuleInner
extends ProxyOnlyResource {
    private RecommendationRuleProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private RecommendationRuleProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public RecommendationRuleInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String recommendationName() {
        return this.innerProperties() == null ? null : this.innerProperties().recommendationName();
    }

    public RecommendationRuleInner withRecommendationName(String recommendationName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationRuleProperties();
        }
        this.innerProperties().withRecommendationName(recommendationName);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public RecommendationRuleInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationRuleProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String message() {
        return this.innerProperties() == null ? null : this.innerProperties().message();
    }

    public RecommendationRuleInner withMessage(String message) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationRuleProperties();
        }
        this.innerProperties().withMessage(message);
        return this;
    }

    public UUID recommendationId() {
        return this.innerProperties() == null ? null : this.innerProperties().recommendationId();
    }

    public RecommendationRuleInner withRecommendationId(UUID recommendationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationRuleProperties();
        }
        this.innerProperties().withRecommendationId(recommendationId);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public RecommendationRuleInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationRuleProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String actionName() {
        return this.innerProperties() == null ? null : this.innerProperties().actionName();
    }

    public RecommendationRuleInner withActionName(String actionName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationRuleProperties();
        }
        this.innerProperties().withActionName(actionName);
        return this;
    }

    public NotificationLevel level() {
        return this.innerProperties() == null ? null : this.innerProperties().level();
    }

    public RecommendationRuleInner withLevel(NotificationLevel level) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationRuleProperties();
        }
        this.innerProperties().withLevel(level);
        return this;
    }

    public Channels channels() {
        return this.innerProperties() == null ? null : this.innerProperties().channels();
    }

    public RecommendationRuleInner withChannels(Channels channels) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationRuleProperties();
        }
        this.innerProperties().withChannels(channels);
        return this;
    }

    public List<String> categoryTags() {
        return this.innerProperties() == null ? null : this.innerProperties().categoryTags();
    }

    public Boolean isDynamic() {
        return this.innerProperties() == null ? null : this.innerProperties().isDynamic();
    }

    public RecommendationRuleInner withIsDynamic(Boolean isDynamic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationRuleProperties();
        }
        this.innerProperties().withIsDynamic(isDynamic);
        return this;
    }

    public String extensionName() {
        return this.innerProperties() == null ? null : this.innerProperties().extensionName();
    }

    public RecommendationRuleInner withExtensionName(String extensionName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationRuleProperties();
        }
        this.innerProperties().withExtensionName(extensionName);
        return this;
    }

    public String bladeName() {
        return this.innerProperties() == null ? null : this.innerProperties().bladeName();
    }

    public RecommendationRuleInner withBladeName(String bladeName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationRuleProperties();
        }
        this.innerProperties().withBladeName(bladeName);
        return this;
    }

    public String forwardLink() {
        return this.innerProperties() == null ? null : this.innerProperties().forwardLink();
    }

    public RecommendationRuleInner withForwardLink(String forwardLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationRuleProperties();
        }
        this.innerProperties().withForwardLink(forwardLink);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RecommendationRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (RecommendationRuleInner)((Object)jsonReader.readObject(reader -> {
            RecommendationRuleInner deserializedRecommendationRuleInner = new RecommendationRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRecommendationRuleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRecommendationRuleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRecommendationRuleInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedRecommendationRuleInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRecommendationRuleInner.innerProperties = RecommendationRuleProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecommendationRuleInner;
        }));
    }
}

