/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.PublicCertificateProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.PublicCertificateLocation;
import java.io.IOException;

public final class PublicCertificateInner
extends ProxyOnlyResource {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private PublicCertificateProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private PublicCertificateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public PublicCertificateInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public byte[] blob() {
        return this.innerProperties() == null ? EMPTY_BYTE_ARRAY : this.innerProperties().blob();
    }

    public PublicCertificateInner withBlob(byte[] blob) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicCertificateProperties();
        }
        this.innerProperties().withBlob(blob);
        return this;
    }

    public PublicCertificateLocation publicCertificateLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().publicCertificateLocation();
    }

    public PublicCertificateInner withPublicCertificateLocation(PublicCertificateLocation publicCertificateLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicCertificateProperties();
        }
        this.innerProperties().withPublicCertificateLocation(publicCertificateLocation);
        return this;
    }

    public String thumbprint() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprint();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PublicCertificateInner fromJson(JsonReader jsonReader) throws IOException {
        return (PublicCertificateInner)((Object)jsonReader.readObject(reader -> {
            PublicCertificateInner deserializedPublicCertificateInner = new PublicCertificateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPublicCertificateInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPublicCertificateInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPublicCertificateInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedPublicCertificateInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPublicCertificateInner.innerProperties = PublicCertificateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPublicCertificateInner;
        }));
    }
}

