/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.ProcessModuleInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.ProcessThreadInfoInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class ProcessInfoProperties
implements JsonSerializable<ProcessInfoProperties> {
    private Integer identifier;
    private String deploymentName;
    private String href;
    private String minidump;
    private Boolean isProfileRunning;
    private Boolean isIisProfileRunning;
    private Double iisProfileTimeoutInSeconds;
    private String parent;
    private List<String> children;
    private List<ProcessThreadInfoInner> threads;
    private List<String> openFileHandles;
    private List<ProcessModuleInfoInner> modules;
    private String fileName;
    private String commandLine;
    private String username;
    private Integer handleCount;
    private Integer moduleCount;
    private Integer threadCount;
    private OffsetDateTime startTime;
    private String totalCpuTime;
    private String userCpuTime;
    private String privilegedCpuTime;
    private Long workingSet;
    private Long peakWorkingSet;
    private Long privateMemory;
    private Long virtualMemory;
    private Long peakVirtualMemory;
    private Long pagedSystemMemory;
    private Long nonPagedSystemMemory;
    private Long pagedMemory;
    private Long peakPagedMemory;
    private OffsetDateTime timestamp;
    private Map<String, String> environmentVariables;
    private Boolean isScmSite;
    private Boolean isWebjob;
    private String description;

    public Integer identifier() {
        return this.identifier;
    }

    public String deploymentName() {
        return this.deploymentName;
    }

    public ProcessInfoProperties withDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public String href() {
        return this.href;
    }

    public ProcessInfoProperties withHref(String href) {
        this.href = href;
        return this;
    }

    public String minidump() {
        return this.minidump;
    }

    public ProcessInfoProperties withMinidump(String minidump) {
        this.minidump = minidump;
        return this;
    }

    public Boolean isProfileRunning() {
        return this.isProfileRunning;
    }

    public ProcessInfoProperties withIsProfileRunning(Boolean isProfileRunning) {
        this.isProfileRunning = isProfileRunning;
        return this;
    }

    public Boolean isIisProfileRunning() {
        return this.isIisProfileRunning;
    }

    public ProcessInfoProperties withIsIisProfileRunning(Boolean isIisProfileRunning) {
        this.isIisProfileRunning = isIisProfileRunning;
        return this;
    }

    public Double iisProfileTimeoutInSeconds() {
        return this.iisProfileTimeoutInSeconds;
    }

    public ProcessInfoProperties withIisProfileTimeoutInSeconds(Double iisProfileTimeoutInSeconds) {
        this.iisProfileTimeoutInSeconds = iisProfileTimeoutInSeconds;
        return this;
    }

    public String parent() {
        return this.parent;
    }

    public ProcessInfoProperties withParent(String parent) {
        this.parent = parent;
        return this;
    }

    public List<String> children() {
        return this.children;
    }

    public ProcessInfoProperties withChildren(List<String> children) {
        this.children = children;
        return this;
    }

    public List<ProcessThreadInfoInner> threads() {
        return this.threads;
    }

    public ProcessInfoProperties withThreads(List<ProcessThreadInfoInner> threads) {
        this.threads = threads;
        return this;
    }

    public List<String> openFileHandles() {
        return this.openFileHandles;
    }

    public ProcessInfoProperties withOpenFileHandles(List<String> openFileHandles) {
        this.openFileHandles = openFileHandles;
        return this;
    }

    public List<ProcessModuleInfoInner> modules() {
        return this.modules;
    }

    public ProcessInfoProperties withModules(List<ProcessModuleInfoInner> modules) {
        this.modules = modules;
        return this;
    }

    public String fileName() {
        return this.fileName;
    }

    public ProcessInfoProperties withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String commandLine() {
        return this.commandLine;
    }

    public ProcessInfoProperties withCommandLine(String commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    public String username() {
        return this.username;
    }

    public ProcessInfoProperties withUsername(String username) {
        this.username = username;
        return this;
    }

    public Integer handleCount() {
        return this.handleCount;
    }

    public ProcessInfoProperties withHandleCount(Integer handleCount) {
        this.handleCount = handleCount;
        return this;
    }

    public Integer moduleCount() {
        return this.moduleCount;
    }

    public ProcessInfoProperties withModuleCount(Integer moduleCount) {
        this.moduleCount = moduleCount;
        return this;
    }

    public Integer threadCount() {
        return this.threadCount;
    }

    public ProcessInfoProperties withThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ProcessInfoProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public String totalCpuTime() {
        return this.totalCpuTime;
    }

    public ProcessInfoProperties withTotalCpuTime(String totalCpuTime) {
        this.totalCpuTime = totalCpuTime;
        return this;
    }

    public String userCpuTime() {
        return this.userCpuTime;
    }

    public ProcessInfoProperties withUserCpuTime(String userCpuTime) {
        this.userCpuTime = userCpuTime;
        return this;
    }

    public String privilegedCpuTime() {
        return this.privilegedCpuTime;
    }

    public ProcessInfoProperties withPrivilegedCpuTime(String privilegedCpuTime) {
        this.privilegedCpuTime = privilegedCpuTime;
        return this;
    }

    public Long workingSet() {
        return this.workingSet;
    }

    public ProcessInfoProperties withWorkingSet(Long workingSet) {
        this.workingSet = workingSet;
        return this;
    }

    public Long peakWorkingSet() {
        return this.peakWorkingSet;
    }

    public ProcessInfoProperties withPeakWorkingSet(Long peakWorkingSet) {
        this.peakWorkingSet = peakWorkingSet;
        return this;
    }

    public Long privateMemory() {
        return this.privateMemory;
    }

    public ProcessInfoProperties withPrivateMemory(Long privateMemory) {
        this.privateMemory = privateMemory;
        return this;
    }

    public Long virtualMemory() {
        return this.virtualMemory;
    }

    public ProcessInfoProperties withVirtualMemory(Long virtualMemory) {
        this.virtualMemory = virtualMemory;
        return this;
    }

    public Long peakVirtualMemory() {
        return this.peakVirtualMemory;
    }

    public ProcessInfoProperties withPeakVirtualMemory(Long peakVirtualMemory) {
        this.peakVirtualMemory = peakVirtualMemory;
        return this;
    }

    public Long pagedSystemMemory() {
        return this.pagedSystemMemory;
    }

    public ProcessInfoProperties withPagedSystemMemory(Long pagedSystemMemory) {
        this.pagedSystemMemory = pagedSystemMemory;
        return this;
    }

    public Long nonPagedSystemMemory() {
        return this.nonPagedSystemMemory;
    }

    public ProcessInfoProperties withNonPagedSystemMemory(Long nonPagedSystemMemory) {
        this.nonPagedSystemMemory = nonPagedSystemMemory;
        return this;
    }

    public Long pagedMemory() {
        return this.pagedMemory;
    }

    public ProcessInfoProperties withPagedMemory(Long pagedMemory) {
        this.pagedMemory = pagedMemory;
        return this;
    }

    public Long peakPagedMemory() {
        return this.peakPagedMemory;
    }

    public ProcessInfoProperties withPeakPagedMemory(Long peakPagedMemory) {
        this.peakPagedMemory = peakPagedMemory;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public ProcessInfoProperties withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public ProcessInfoProperties withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public Boolean isScmSite() {
        return this.isScmSite;
    }

    public ProcessInfoProperties withIsScmSite(Boolean isScmSite) {
        this.isScmSite = isScmSite;
        return this;
    }

    public Boolean isWebjob() {
        return this.isWebjob;
    }

    public ProcessInfoProperties withIsWebjob(Boolean isWebjob) {
        this.isWebjob = isWebjob;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ProcessInfoProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.threads() != null) {
            this.threads().forEach(e -> e.validate());
        }
        if (this.modules() != null) {
            this.modules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deployment_name", this.deploymentName);
        jsonWriter.writeStringField("href", this.href);
        jsonWriter.writeStringField("minidump", this.minidump);
        jsonWriter.writeBooleanField("is_profile_running", this.isProfileRunning);
        jsonWriter.writeBooleanField("is_iis_profile_running", this.isIisProfileRunning);
        jsonWriter.writeNumberField("iis_profile_timeout_in_seconds", (Number)this.iisProfileTimeoutInSeconds);
        jsonWriter.writeStringField("parent", this.parent);
        jsonWriter.writeArrayField("children", this.children, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("threads", this.threads, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("open_file_handles", this.openFileHandles, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("modules", this.modules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("file_name", this.fileName);
        jsonWriter.writeStringField("command_line", this.commandLine);
        jsonWriter.writeStringField("user_name", this.username);
        jsonWriter.writeNumberField("handle_count", (Number)this.handleCount);
        jsonWriter.writeNumberField("module_count", (Number)this.moduleCount);
        jsonWriter.writeNumberField("thread_count", (Number)this.threadCount);
        jsonWriter.writeStringField("start_time", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("total_cpu_time", this.totalCpuTime);
        jsonWriter.writeStringField("user_cpu_time", this.userCpuTime);
        jsonWriter.writeStringField("privileged_cpu_time", this.privilegedCpuTime);
        jsonWriter.writeNumberField("working_set", (Number)this.workingSet);
        jsonWriter.writeNumberField("peak_working_set", (Number)this.peakWorkingSet);
        jsonWriter.writeNumberField("private_memory", (Number)this.privateMemory);
        jsonWriter.writeNumberField("virtual_memory", (Number)this.virtualMemory);
        jsonWriter.writeNumberField("peak_virtual_memory", (Number)this.peakVirtualMemory);
        jsonWriter.writeNumberField("paged_system_memory", (Number)this.pagedSystemMemory);
        jsonWriter.writeNumberField("non_paged_system_memory", (Number)this.nonPagedSystemMemory);
        jsonWriter.writeNumberField("paged_memory", (Number)this.pagedMemory);
        jsonWriter.writeNumberField("peak_paged_memory", (Number)this.peakPagedMemory);
        jsonWriter.writeStringField("time_stamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeMapField("environment_variables", this.environmentVariables, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("is_scm_site", this.isScmSite);
        jsonWriter.writeBooleanField("is_webjob", this.isWebjob);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ProcessInfoProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProcessInfoProperties)jsonReader.readObject(reader -> {
            ProcessInfoProperties deserializedProcessInfoProperties = new ProcessInfoProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identifier".equals(fieldName)) {
                    deserializedProcessInfoProperties.identifier = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("deployment_name".equals(fieldName)) {
                    deserializedProcessInfoProperties.deploymentName = reader.getString();
                    continue;
                }
                if ("href".equals(fieldName)) {
                    deserializedProcessInfoProperties.href = reader.getString();
                    continue;
                }
                if ("minidump".equals(fieldName)) {
                    deserializedProcessInfoProperties.minidump = reader.getString();
                    continue;
                }
                if ("is_profile_running".equals(fieldName)) {
                    deserializedProcessInfoProperties.isProfileRunning = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("is_iis_profile_running".equals(fieldName)) {
                    deserializedProcessInfoProperties.isIisProfileRunning = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("iis_profile_timeout_in_seconds".equals(fieldName)) {
                    deserializedProcessInfoProperties.iisProfileTimeoutInSeconds = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("parent".equals(fieldName)) {
                    deserializedProcessInfoProperties.parent = reader.getString();
                    continue;
                }
                if ("children".equals(fieldName)) {
                    List children;
                    deserializedProcessInfoProperties.children = children = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("threads".equals(fieldName)) {
                    List threads;
                    deserializedProcessInfoProperties.threads = threads = reader.readArray(reader1 -> ProcessThreadInfoInner.fromJson(reader1));
                    continue;
                }
                if ("open_file_handles".equals(fieldName)) {
                    List openFileHandles;
                    deserializedProcessInfoProperties.openFileHandles = openFileHandles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("modules".equals(fieldName)) {
                    List modules;
                    deserializedProcessInfoProperties.modules = modules = reader.readArray(reader1 -> ProcessModuleInfoInner.fromJson(reader1));
                    continue;
                }
                if ("file_name".equals(fieldName)) {
                    deserializedProcessInfoProperties.fileName = reader.getString();
                    continue;
                }
                if ("command_line".equals(fieldName)) {
                    deserializedProcessInfoProperties.commandLine = reader.getString();
                    continue;
                }
                if ("user_name".equals(fieldName)) {
                    deserializedProcessInfoProperties.username = reader.getString();
                    continue;
                }
                if ("handle_count".equals(fieldName)) {
                    deserializedProcessInfoProperties.handleCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("module_count".equals(fieldName)) {
                    deserializedProcessInfoProperties.moduleCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("thread_count".equals(fieldName)) {
                    deserializedProcessInfoProperties.threadCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("start_time".equals(fieldName)) {
                    deserializedProcessInfoProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("total_cpu_time".equals(fieldName)) {
                    deserializedProcessInfoProperties.totalCpuTime = reader.getString();
                    continue;
                }
                if ("user_cpu_time".equals(fieldName)) {
                    deserializedProcessInfoProperties.userCpuTime = reader.getString();
                    continue;
                }
                if ("privileged_cpu_time".equals(fieldName)) {
                    deserializedProcessInfoProperties.privilegedCpuTime = reader.getString();
                    continue;
                }
                if ("working_set".equals(fieldName)) {
                    deserializedProcessInfoProperties.workingSet = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("peak_working_set".equals(fieldName)) {
                    deserializedProcessInfoProperties.peakWorkingSet = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("private_memory".equals(fieldName)) {
                    deserializedProcessInfoProperties.privateMemory = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("virtual_memory".equals(fieldName)) {
                    deserializedProcessInfoProperties.virtualMemory = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("peak_virtual_memory".equals(fieldName)) {
                    deserializedProcessInfoProperties.peakVirtualMemory = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("paged_system_memory".equals(fieldName)) {
                    deserializedProcessInfoProperties.pagedSystemMemory = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("non_paged_system_memory".equals(fieldName)) {
                    deserializedProcessInfoProperties.nonPagedSystemMemory = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("paged_memory".equals(fieldName)) {
                    deserializedProcessInfoProperties.pagedMemory = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("peak_paged_memory".equals(fieldName)) {
                    deserializedProcessInfoProperties.peakPagedMemory = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("time_stamp".equals(fieldName)) {
                    deserializedProcessInfoProperties.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("environment_variables".equals(fieldName)) {
                    Map environmentVariables;
                    deserializedProcessInfoProperties.environmentVariables = environmentVariables = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("is_scm_site".equals(fieldName)) {
                    deserializedProcessInfoProperties.isScmSite = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("is_webjob".equals(fieldName)) {
                    deserializedProcessInfoProperties.isWebjob = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedProcessInfoProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProcessInfoProperties;
        });
    }
}

