/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.FunctionAppMajorVersion;
import com.azure.resourcemanager.appservice.models.StackPreferredOs;
import java.io.IOException;
import java.util.List;

public final class FunctionAppStackProperties
implements JsonSerializable<FunctionAppStackProperties> {
    private String displayText;
    private String value;
    private List<FunctionAppMajorVersion> majorVersions;
    private StackPreferredOs preferredOs;

    public String displayText() {
        return this.displayText;
    }

    public String value() {
        return this.value;
    }

    public List<FunctionAppMajorVersion> majorVersions() {
        return this.majorVersions;
    }

    public StackPreferredOs preferredOs() {
        return this.preferredOs;
    }

    public void validate() {
        if (this.majorVersions() != null) {
            this.majorVersions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static FunctionAppStackProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FunctionAppStackProperties)jsonReader.readObject(reader -> {
            FunctionAppStackProperties deserializedFunctionAppStackProperties = new FunctionAppStackProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayText".equals(fieldName)) {
                    deserializedFunctionAppStackProperties.displayText = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedFunctionAppStackProperties.value = reader.getString();
                    continue;
                }
                if ("majorVersions".equals(fieldName)) {
                    List majorVersions;
                    deserializedFunctionAppStackProperties.majorVersions = majorVersions = reader.readArray(reader1 -> FunctionAppMajorVersion.fromJson(reader1));
                    continue;
                }
                if ("preferredOs".equals(fieldName)) {
                    deserializedFunctionAppStackProperties.preferredOs = StackPreferredOs.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFunctionAppStackProperties;
        });
    }
}

