/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ConnStringValueTypePair;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.Map;

public final class ConnectionStringDictionaryInner
extends ProxyOnlyResource {
    private Map<String, ConnStringValueTypePair> properties;
    private String type;
    private String name;
    private String id;

    public Map<String, ConnStringValueTypePair> properties() {
        return this.properties;
    }

    public ConnectionStringDictionaryInner withProperties(Map<String, ConnStringValueTypePair> properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ConnectionStringDictionaryInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() != null) {
            this.properties().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ConnectionStringDictionaryInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionStringDictionaryInner)((Object)jsonReader.readObject(reader -> {
            ConnectionStringDictionaryInner deserializedConnectionStringDictionaryInner = new ConnectionStringDictionaryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConnectionStringDictionaryInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConnectionStringDictionaryInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConnectionStringDictionaryInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedConnectionStringDictionaryInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedConnectionStringDictionaryInner.properties = properties = reader.readMap(reader1 -> ConnStringValueTypePair.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionStringDictionaryInner;
        }));
    }
}

