/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AzureResourceType;
import com.azure.resourcemanager.appservice.models.CustomHostnameDnsRecordType;
import com.azure.resourcemanager.appservice.models.HostnameType;
import java.io.IOException;
import java.util.List;

public final class Hostname
implements JsonSerializable<Hostname> {
    private String name;
    private List<String> siteNames;
    private String azureResourceName;
    private AzureResourceType azureResourceType;
    private CustomHostnameDnsRecordType customHostnameDnsRecordType;
    private HostnameType hostnameType;

    public String name() {
        return this.name;
    }

    public Hostname withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> siteNames() {
        return this.siteNames;
    }

    public Hostname withSiteNames(List<String> siteNames) {
        this.siteNames = siteNames;
        return this;
    }

    public String azureResourceName() {
        return this.azureResourceName;
    }

    public Hostname withAzureResourceName(String azureResourceName) {
        this.azureResourceName = azureResourceName;
        return this;
    }

    public AzureResourceType azureResourceType() {
        return this.azureResourceType;
    }

    public Hostname withAzureResourceType(AzureResourceType azureResourceType) {
        this.azureResourceType = azureResourceType;
        return this;
    }

    public CustomHostnameDnsRecordType customHostnameDnsRecordType() {
        return this.customHostnameDnsRecordType;
    }

    public Hostname withCustomHostnameDnsRecordType(CustomHostnameDnsRecordType customHostnameDnsRecordType) {
        this.customHostnameDnsRecordType = customHostnameDnsRecordType;
        return this;
    }

    public HostnameType hostnameType() {
        return this.hostnameType;
    }

    public Hostname withHostnameType(HostnameType hostnameType) {
        this.hostnameType = hostnameType;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("siteNames", this.siteNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("azureResourceName", this.azureResourceName);
        jsonWriter.writeStringField("azureResourceType", this.azureResourceType == null ? null : this.azureResourceType.toString());
        jsonWriter.writeStringField("customHostNameDnsRecordType", this.customHostnameDnsRecordType == null ? null : this.customHostnameDnsRecordType.toString());
        jsonWriter.writeStringField("hostNameType", this.hostnameType == null ? null : this.hostnameType.toString());
        return jsonWriter.writeEndObject();
    }

    public static Hostname fromJson(JsonReader jsonReader) throws IOException {
        return (Hostname)jsonReader.readObject(reader -> {
            Hostname deserializedHostname = new Hostname();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedHostname.name = reader.getString();
                    continue;
                }
                if ("siteNames".equals(fieldName)) {
                    List siteNames;
                    deserializedHostname.siteNames = siteNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("azureResourceName".equals(fieldName)) {
                    deserializedHostname.azureResourceName = reader.getString();
                    continue;
                }
                if ("azureResourceType".equals(fieldName)) {
                    deserializedHostname.azureResourceType = AzureResourceType.fromString(reader.getString());
                    continue;
                }
                if ("customHostNameDnsRecordType".equals(fieldName)) {
                    deserializedHostname.customHostnameDnsRecordType = CustomHostnameDnsRecordType.fromString(reader.getString());
                    continue;
                }
                if ("hostNameType".equals(fieldName)) {
                    deserializedHostname.hostnameType = HostnameType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHostname;
        });
    }
}

