/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ScaleRuleAuth;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CustomScaleRule
implements JsonSerializable<CustomScaleRule> {
    private String type;
    private Map<String, String> metadata;
    private List<ScaleRuleAuth> auth;

    public String type() {
        return this.type;
    }

    public CustomScaleRule withType(String type) {
        this.type = type;
        return this;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public CustomScaleRule withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<ScaleRuleAuth> auth() {
        return this.auth;
    }

    public CustomScaleRule withAuth(List<ScaleRuleAuth> auth) {
        this.auth = auth;
        return this;
    }

    public void validate() {
        if (this.auth() != null) {
            this.auth().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("auth", this.auth, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CustomScaleRule fromJson(JsonReader jsonReader) throws IOException {
        return (CustomScaleRule)jsonReader.readObject(reader -> {
            CustomScaleRule deserializedCustomScaleRule = new CustomScaleRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedCustomScaleRule.type = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedCustomScaleRule.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("auth".equals(fieldName)) {
                    List auth;
                    deserializedCustomScaleRule.auth = auth = reader.readArray(reader1 -> ScaleRuleAuth.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomScaleRule;
        });
    }
}

