/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AzureStorageInfoValue;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.Map;

public final class AzureStoragePropertyDictionaryResourceInner
extends ProxyOnlyResource {
    private Map<String, AzureStorageInfoValue> properties;
    private String type;
    private String name;
    private String id;

    public Map<String, AzureStorageInfoValue> properties() {
        return this.properties;
    }

    public AzureStoragePropertyDictionaryResourceInner withProperties(Map<String, AzureStorageInfoValue> properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public AzureStoragePropertyDictionaryResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() != null) {
            this.properties().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureStoragePropertyDictionaryResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (AzureStoragePropertyDictionaryResourceInner)((Object)jsonReader.readObject(reader -> {
            AzureStoragePropertyDictionaryResourceInner deserializedAzureStoragePropertyDictionaryResourceInner = new AzureStoragePropertyDictionaryResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAzureStoragePropertyDictionaryResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAzureStoragePropertyDictionaryResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureStoragePropertyDictionaryResourceInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedAzureStoragePropertyDictionaryResourceInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedAzureStoragePropertyDictionaryResourceInner.properties = properties = reader.readMap(reader1 -> AzureStorageInfoValue.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureStoragePropertyDictionaryResourceInner;
        }));
    }
}

