/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.StaticSitesWorkflowPreviewRequestProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildProperties;
import java.io.IOException;

public final class StaticSitesWorkflowPreviewRequest
extends ProxyOnlyResource {
    private StaticSitesWorkflowPreviewRequestProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private StaticSitesWorkflowPreviewRequestProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public StaticSitesWorkflowPreviewRequest withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String repositoryUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().repositoryUrl();
    }

    public StaticSitesWorkflowPreviewRequest withRepositoryUrl(String repositoryUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSitesWorkflowPreviewRequestProperties();
        }
        this.innerProperties().withRepositoryUrl(repositoryUrl);
        return this;
    }

    public String branch() {
        return this.innerProperties() == null ? null : this.innerProperties().branch();
    }

    public StaticSitesWorkflowPreviewRequest withBranch(String branch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSitesWorkflowPreviewRequestProperties();
        }
        this.innerProperties().withBranch(branch);
        return this;
    }

    public StaticSiteBuildProperties buildProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().buildProperties();
    }

    public StaticSitesWorkflowPreviewRequest withBuildProperties(StaticSiteBuildProperties buildProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSitesWorkflowPreviewRequestProperties();
        }
        this.innerProperties().withBuildProperties(buildProperties);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static StaticSitesWorkflowPreviewRequest fromJson(JsonReader jsonReader) throws IOException {
        return (StaticSitesWorkflowPreviewRequest)((Object)jsonReader.readObject(reader -> {
            StaticSitesWorkflowPreviewRequest deserializedStaticSitesWorkflowPreviewRequest = new StaticSitesWorkflowPreviewRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedStaticSitesWorkflowPreviewRequest.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedStaticSitesWorkflowPreviewRequest.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStaticSitesWorkflowPreviewRequest.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedStaticSitesWorkflowPreviewRequest.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStaticSitesWorkflowPreviewRequest.innerProperties = StaticSitesWorkflowPreviewRequestProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStaticSitesWorkflowPreviewRequest;
        }));
    }
}

