/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ContainerCpuUsage;
import com.azure.resourcemanager.appservice.models.ContainerThrottlingData;
import java.io.IOException;

public final class ContainerCpuStatistics
implements JsonSerializable<ContainerCpuStatistics> {
    private ContainerCpuUsage cpuUsage;
    private Long systemCpuUsage;
    private Integer onlineCpuCount;
    private ContainerThrottlingData throttlingData;

    public ContainerCpuUsage cpuUsage() {
        return this.cpuUsage;
    }

    public ContainerCpuStatistics withCpuUsage(ContainerCpuUsage cpuUsage) {
        this.cpuUsage = cpuUsage;
        return this;
    }

    public Long systemCpuUsage() {
        return this.systemCpuUsage;
    }

    public ContainerCpuStatistics withSystemCpuUsage(Long systemCpuUsage) {
        this.systemCpuUsage = systemCpuUsage;
        return this;
    }

    public Integer onlineCpuCount() {
        return this.onlineCpuCount;
    }

    public ContainerCpuStatistics withOnlineCpuCount(Integer onlineCpuCount) {
        this.onlineCpuCount = onlineCpuCount;
        return this;
    }

    public ContainerThrottlingData throttlingData() {
        return this.throttlingData;
    }

    public ContainerCpuStatistics withThrottlingData(ContainerThrottlingData throttlingData) {
        this.throttlingData = throttlingData;
        return this;
    }

    public void validate() {
        if (this.cpuUsage() != null) {
            this.cpuUsage().validate();
        }
        if (this.throttlingData() != null) {
            this.throttlingData().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("cpuUsage", (JsonSerializable)this.cpuUsage);
        jsonWriter.writeNumberField("systemCpuUsage", (Number)this.systemCpuUsage);
        jsonWriter.writeNumberField("onlineCpuCount", (Number)this.onlineCpuCount);
        jsonWriter.writeJsonField("throttlingData", (JsonSerializable)this.throttlingData);
        return jsonWriter.writeEndObject();
    }

    public static ContainerCpuStatistics fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerCpuStatistics)jsonReader.readObject(reader -> {
            ContainerCpuStatistics deserializedContainerCpuStatistics = new ContainerCpuStatistics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cpuUsage".equals(fieldName)) {
                    deserializedContainerCpuStatistics.cpuUsage = ContainerCpuUsage.fromJson(reader);
                    continue;
                }
                if ("systemCpuUsage".equals(fieldName)) {
                    deserializedContainerCpuStatistics.systemCpuUsage = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("onlineCpuCount".equals(fieldName)) {
                    deserializedContainerCpuStatistics.onlineCpuCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("throttlingData".equals(fieldName)) {
                    deserializedContainerCpuStatistics.throttlingData = ContainerThrottlingData.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerCpuStatistics;
        });
    }
}

