// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * The configuration settings of each of the identity providers used to configure App Service
 * Authentication/Authorization.
 */
@Fluent
public final class IdentityProviders {
    /*
     * The configuration settings of the Azure Active directory provider.
     */
    @JsonProperty(value = "azureActiveDirectory")
    private AzureActiveDirectory azureActiveDirectory;

    /*
     * The configuration settings of the Facebook provider.
     */
    @JsonProperty(value = "facebook")
    private Facebook facebook;

    /*
     * The configuration settings of the GitHub provider.
     */
    @JsonProperty(value = "gitHub")
    private GitHub gitHub;

    /*
     * The configuration settings of the Google provider.
     */
    @JsonProperty(value = "google")
    private Google google;

    /*
     * The configuration settings of the legacy Microsoft Account provider.
     */
    @JsonProperty(value = "legacyMicrosoftAccount")
    private LegacyMicrosoftAccount legacyMicrosoftAccount;

    /*
     * The configuration settings of the Twitter provider.
     */
    @JsonProperty(value = "twitter")
    private Twitter twitter;

    /*
     * The configuration settings of the Apple provider.
     */
    @JsonProperty(value = "apple")
    private Apple apple;

    /*
     * The configuration settings of the Azure Static Web Apps provider.
     */
    @JsonProperty(value = "azureStaticWebApps")
    private AzureStaticWebApps azureStaticWebApps;

    /*
     * The map of the name of the alias of each custom Open ID Connect provider
     * to the
     * configuration settings of the custom Open ID Connect provider.
     */
    @JsonProperty(value = "customOpenIdConnectProviders")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, CustomOpenIdConnectProvider> customOpenIdConnectProviders;

    /**
     * Get the azureActiveDirectory property: The configuration settings of the Azure Active directory provider.
     *
     * @return the azureActiveDirectory value.
     */
    public AzureActiveDirectory azureActiveDirectory() {
        return this.azureActiveDirectory;
    }

    /**
     * Set the azureActiveDirectory property: The configuration settings of the Azure Active directory provider.
     *
     * @param azureActiveDirectory the azureActiveDirectory value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withAzureActiveDirectory(AzureActiveDirectory azureActiveDirectory) {
        this.azureActiveDirectory = azureActiveDirectory;
        return this;
    }

    /**
     * Get the facebook property: The configuration settings of the Facebook provider.
     *
     * @return the facebook value.
     */
    public Facebook facebook() {
        return this.facebook;
    }

    /**
     * Set the facebook property: The configuration settings of the Facebook provider.
     *
     * @param facebook the facebook value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withFacebook(Facebook facebook) {
        this.facebook = facebook;
        return this;
    }

    /**
     * Get the gitHub property: The configuration settings of the GitHub provider.
     *
     * @return the gitHub value.
     */
    public GitHub gitHub() {
        return this.gitHub;
    }

    /**
     * Set the gitHub property: The configuration settings of the GitHub provider.
     *
     * @param gitHub the gitHub value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withGitHub(GitHub gitHub) {
        this.gitHub = gitHub;
        return this;
    }

    /**
     * Get the google property: The configuration settings of the Google provider.
     *
     * @return the google value.
     */
    public Google google() {
        return this.google;
    }

    /**
     * Set the google property: The configuration settings of the Google provider.
     *
     * @param google the google value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withGoogle(Google google) {
        this.google = google;
        return this;
    }

    /**
     * Get the legacyMicrosoftAccount property: The configuration settings of the legacy Microsoft Account provider.
     *
     * @return the legacyMicrosoftAccount value.
     */
    public LegacyMicrosoftAccount legacyMicrosoftAccount() {
        return this.legacyMicrosoftAccount;
    }

    /**
     * Set the legacyMicrosoftAccount property: The configuration settings of the legacy Microsoft Account provider.
     *
     * @param legacyMicrosoftAccount the legacyMicrosoftAccount value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withLegacyMicrosoftAccount(LegacyMicrosoftAccount legacyMicrosoftAccount) {
        this.legacyMicrosoftAccount = legacyMicrosoftAccount;
        return this;
    }

    /**
     * Get the twitter property: The configuration settings of the Twitter provider.
     *
     * @return the twitter value.
     */
    public Twitter twitter() {
        return this.twitter;
    }

    /**
     * Set the twitter property: The configuration settings of the Twitter provider.
     *
     * @param twitter the twitter value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withTwitter(Twitter twitter) {
        this.twitter = twitter;
        return this;
    }

    /**
     * Get the apple property: The configuration settings of the Apple provider.
     *
     * @return the apple value.
     */
    public Apple apple() {
        return this.apple;
    }

    /**
     * Set the apple property: The configuration settings of the Apple provider.
     *
     * @param apple the apple value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withApple(Apple apple) {
        this.apple = apple;
        return this;
    }

    /**
     * Get the azureStaticWebApps property: The configuration settings of the Azure Static Web Apps provider.
     *
     * @return the azureStaticWebApps value.
     */
    public AzureStaticWebApps azureStaticWebApps() {
        return this.azureStaticWebApps;
    }

    /**
     * Set the azureStaticWebApps property: The configuration settings of the Azure Static Web Apps provider.
     *
     * @param azureStaticWebApps the azureStaticWebApps value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withAzureStaticWebApps(AzureStaticWebApps azureStaticWebApps) {
        this.azureStaticWebApps = azureStaticWebApps;
        return this;
    }

    /**
     * Get the customOpenIdConnectProviders property: The map of the name of the alias of each custom Open ID Connect
     * provider to the configuration settings of the custom Open ID Connect provider.
     *
     * @return the customOpenIdConnectProviders value.
     */
    public Map<String, CustomOpenIdConnectProvider> customOpenIdConnectProviders() {
        return this.customOpenIdConnectProviders;
    }

    /**
     * Set the customOpenIdConnectProviders property: The map of the name of the alias of each custom Open ID Connect
     * provider to the configuration settings of the custom Open ID Connect provider.
     *
     * @param customOpenIdConnectProviders the customOpenIdConnectProviders value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withCustomOpenIdConnectProviders(
        Map<String, CustomOpenIdConnectProvider> customOpenIdConnectProviders) {
        this.customOpenIdConnectProviders = customOpenIdConnectProviders;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (azureActiveDirectory() != null) {
            azureActiveDirectory().validate();
        }
        if (facebook() != null) {
            facebook().validate();
        }
        if (gitHub() != null) {
            gitHub().validate();
        }
        if (google() != null) {
            google().validate();
        }
        if (legacyMicrosoftAccount() != null) {
            legacyMicrosoftAccount().validate();
        }
        if (twitter() != null) {
            twitter().validate();
        }
        if (apple() != null) {
            apple().validate();
        }
        if (azureStaticWebApps() != null) {
            azureStaticWebApps().validate();
        }
        if (customOpenIdConnectProviders() != null) {
            customOpenIdConnectProviders()
                .values()
                .forEach(
                    e -> {
                        if (e != null) {
                            e.validate();
                        }
                    });
        }
    }
}
