// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Application logs to Azure table storage configuration. */
@Fluent
public final class AzureTableStorageApplicationLogsConfig {
    /*
     * Log level.
     */
    @JsonProperty(value = "level")
    private LogLevel level;

    /*
     * SAS URL to an Azure table with add/query/delete permissions.
     */
    @JsonProperty(value = "sasUrl", required = true)
    private String sasUrl;

    /**
     * Get the level property: Log level.
     *
     * @return the level value.
     */
    public LogLevel level() {
        return this.level;
    }

    /**
     * Set the level property: Log level.
     *
     * @param level the level value to set.
     * @return the AzureTableStorageApplicationLogsConfig object itself.
     */
    public AzureTableStorageApplicationLogsConfig withLevel(LogLevel level) {
        this.level = level;
        return this;
    }

    /**
     * Get the sasUrl property: SAS URL to an Azure table with add/query/delete permissions.
     *
     * @return the sasUrl value.
     */
    public String sasUrl() {
        return this.sasUrl;
    }

    /**
     * Set the sasUrl property: SAS URL to an Azure table with add/query/delete permissions.
     *
     * @param sasUrl the sasUrl value to set.
     * @return the AzureTableStorageApplicationLogsConfig object itself.
     */
    public AzureTableStorageApplicationLogsConfig withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sasUrl() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property sasUrl in model AzureTableStorageApplicationLogsConfig"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureTableStorageApplicationLogsConfig.class);
}
