// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The configuration settings of the platform of App Service Authentication/Authorization. */
@Fluent
public final class AuthPlatform {
    /*
     * <code>true</code> if the Authentication / Authorization feature is
     * enabled for the current app; otherwise, <code>false</code>.
     */
    @JsonProperty(value = "enabled")
    private Boolean enabled;

    /*
     * The RuntimeVersion of the Authentication / Authorization feature in use
     * for the current app.
     * The setting in this value can control the behavior of certain features
     * in the Authentication / Authorization module.
     */
    @JsonProperty(value = "runtimeVersion")
    private String runtimeVersion;

    /*
     * The path of the config file containing auth settings if they come from a
     * file.
     * If the path is relative, base will the site's root directory.
     */
    @JsonProperty(value = "configFilePath")
    private String configFilePath;

    /**
     * Get the enabled property: &lt;code&gt;true&lt;/code&gt; if the Authentication / Authorization feature is enabled
     * for the current app; otherwise, &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: &lt;code&gt;true&lt;/code&gt; if the Authentication / Authorization feature is enabled
     * for the current app; otherwise, &lt;code&gt;false&lt;/code&gt;.
     *
     * @param enabled the enabled value to set.
     * @return the AuthPlatform object itself.
     */
    public AuthPlatform withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the runtimeVersion property: The RuntimeVersion of the Authentication / Authorization feature in use for the
     * current app. The setting in this value can control the behavior of certain features in the Authentication /
     * Authorization module.
     *
     * @return the runtimeVersion value.
     */
    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    /**
     * Set the runtimeVersion property: The RuntimeVersion of the Authentication / Authorization feature in use for the
     * current app. The setting in this value can control the behavior of certain features in the Authentication /
     * Authorization module.
     *
     * @param runtimeVersion the runtimeVersion value to set.
     * @return the AuthPlatform object itself.
     */
    public AuthPlatform withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    /**
     * Get the configFilePath property: The path of the config file containing auth settings if they come from a file.
     * If the path is relative, base will the site's root directory.
     *
     * @return the configFilePath value.
     */
    public String configFilePath() {
        return this.configFilePath;
    }

    /**
     * Set the configFilePath property: The path of the config file containing auth settings if they come from a file.
     * If the path is relative, base will the site's root directory.
     *
     * @param configFilePath the configFilePath value to set.
     * @return the AuthPlatform object itself.
     */
    public AuthPlatform withConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
