// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.appservice.fluent.DiagnosticsClient;
import com.azure.resourcemanager.appservice.fluent.models.AnalysisDefinitionInner;
import com.azure.resourcemanager.appservice.fluent.models.DetectorDefinitionResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.DetectorResponseInner;
import com.azure.resourcemanager.appservice.fluent.models.DiagnosticAnalysisInner;
import com.azure.resourcemanager.appservice.fluent.models.DiagnosticCategoryInner;
import com.azure.resourcemanager.appservice.fluent.models.DiagnosticDetectorResponseInner;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appservice.models.DetectorResponseCollection;
import com.azure.resourcemanager.appservice.models.DiagnosticAnalysisCollection;
import com.azure.resourcemanager.appservice.models.DiagnosticCategoryCollection;
import com.azure.resourcemanager.appservice.models.DiagnosticDetectorCollection;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DiagnosticsClient. */
public final class DiagnosticsClientImpl implements DiagnosticsClient {
    /** The proxy service used to perform REST calls. */
    private final DiagnosticsService service;

    /** The service client containing this operation class. */
    private final WebSiteManagementClientImpl client;

    /**
     * Initializes an instance of DiagnosticsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DiagnosticsClientImpl(WebSiteManagementClientImpl client) {
        this.service =
            RestProxy.create(DiagnosticsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for WebSiteManagementClientDiagnostics to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "WebSiteManagementCli")
    private interface DiagnosticsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web"
                + "/hostingEnvironments/{name}/detectors")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DetectorResponseCollection>> listHostingEnvironmentDetectorResponses(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web"
                + "/hostingEnvironments/{name}/detectors/{detectorName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DetectorResponseInner>> getHostingEnvironmentDetectorResponse(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("name") String name,
            @PathParam("detectorName") String detectorName,
            @QueryParam("startTime") OffsetDateTime startTime,
            @QueryParam("endTime") OffsetDateTime endTime,
            @QueryParam("timeGrain") String timeGrain,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/detectors")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DetectorResponseCollection>> listSiteDetectorResponses(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/detectors/{detectorName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DetectorResponseInner>> getSiteDetectorResponse(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("detectorName") String detectorName,
            @QueryParam("startTime") OffsetDateTime startTime,
            @QueryParam("endTime") OffsetDateTime endTime,
            @QueryParam("timeGrain") String timeGrain,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/diagnostics")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticCategoryCollection>> listSiteDiagnosticCategories(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/diagnostics/{diagnosticCategory}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticCategoryInner>> getSiteDiagnosticCategory(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/diagnostics/{diagnosticCategory}/analyses")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticAnalysisCollection>> listSiteAnalyses(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<AnalysisDefinitionInner>> getSiteAnalysis(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("analysisName") String analysisName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticAnalysisInner>> executeSiteAnalysis(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("analysisName") String analysisName,
            @QueryParam("startTime") OffsetDateTime startTime,
            @QueryParam("endTime") OffsetDateTime endTime,
            @QueryParam("timeGrain") String timeGrain,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/diagnostics/{diagnosticCategory}/detectors")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticDetectorCollection>> listSiteDetectors(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DetectorDefinitionResourceInner>> getSiteDetector(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("detectorName") String detectorName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticDetectorResponseInner>> executeSiteDetector(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("detectorName") String detectorName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @QueryParam("startTime") OffsetDateTime startTime,
            @QueryParam("endTime") OffsetDateTime endTime,
            @QueryParam("timeGrain") String timeGrain,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/slots/{slot}/detectors")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DetectorResponseCollection>> listSiteDetectorResponsesSlot(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/slots/{slot}/detectors/{detectorName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DetectorResponseInner>> getSiteDetectorResponseSlot(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("detectorName") String detectorName,
            @PathParam("slot") String slot,
            @QueryParam("startTime") OffsetDateTime startTime,
            @QueryParam("endTime") OffsetDateTime endTime,
            @QueryParam("timeGrain") String timeGrain,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/slots/{slot}/diagnostics")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticCategoryCollection>> listSiteDiagnosticCategoriesSlot(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticCategoryInner>> getSiteDiagnosticCategorySlot(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticAnalysisCollection>> listSiteAnalysesSlot(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<AnalysisDefinitionInner>> getSiteAnalysisSlot(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("analysisName") String analysisName,
            @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticAnalysisInner>> executeSiteAnalysisSlot(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("analysisName") String analysisName,
            @PathParam("slot") String slot,
            @QueryParam("startTime") OffsetDateTime startTime,
            @QueryParam("endTime") OffsetDateTime endTime,
            @QueryParam("timeGrain") String timeGrain,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticDetectorCollection>> listSiteDetectorsSlot(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DetectorDefinitionResourceInner>> getSiteDetectorSlot(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("detectorName") String detectorName,
            @PathParam("slot") String slot,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
                + "/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticDetectorResponseInner>> executeSiteDetectorSlot(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("siteName") String siteName,
            @PathParam("detectorName") String detectorName,
            @PathParam("diagnosticCategory") String diagnosticCategory,
            @PathParam("slot") String slot,
            @QueryParam("startTime") OffsetDateTime startTime,
            @QueryParam("endTime") OffsetDateTime endTime,
            @QueryParam("timeGrain") String timeGrain,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DetectorResponseCollection>> listHostingEnvironmentDetectorResponsesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DetectorResponseCollection>> listSiteDetectorResponsesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticCategoryCollection>> listSiteDiagnosticCategoriesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticAnalysisCollection>> listSiteAnalysesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticDetectorCollection>> listSiteDetectorsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DetectorResponseCollection>> listSiteDetectorResponsesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticCategoryCollection>> listSiteDiagnosticCategoriesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticAnalysisCollection>> listSiteAnalysesSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticDetectorCollection>> listSiteDetectorsSlotNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listHostingEnvironmentDetectorResponsesSinglePageAsync(
        String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listHostingEnvironmentDetectorResponses(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            name,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<DetectorResponseInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listHostingEnvironmentDetectorResponsesSinglePageAsync(
        String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listHostingEnvironmentDetectorResponses(
                this.client.getEndpoint(),
                resourceGroupName,
                name,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DetectorResponseInner> listHostingEnvironmentDetectorResponsesAsync(
        String resourceGroupName, String name) {
        return new PagedFlux<>(
            () -> listHostingEnvironmentDetectorResponsesSinglePageAsync(resourceGroupName, name),
            nextLink -> listHostingEnvironmentDetectorResponsesNextSinglePageAsync(nextLink));
    }

    /**
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DetectorResponseInner> listHostingEnvironmentDetectorResponsesAsync(
        String resourceGroupName, String name, Context context) {
        return new PagedFlux<>(
            () -> listHostingEnvironmentDetectorResponsesSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listHostingEnvironmentDetectorResponsesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DetectorResponseInner> listHostingEnvironmentDetectorResponses(
        String resourceGroupName, String name) {
        return new PagedIterable<>(listHostingEnvironmentDetectorResponsesAsync(resourceGroupName, name));
    }

    /**
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DetectorResponseInner> listHostingEnvironmentDetectorResponses(
        String resourceGroupName, String name, Context context) {
        return new PagedIterable<>(listHostingEnvironmentDetectorResponsesAsync(resourceGroupName, name, context));
    }

    /**
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DetectorResponseInner>> getHostingEnvironmentDetectorResponseWithResponseAsync(
        String resourceGroupName,
        String name,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getHostingEnvironmentDetectorResponse(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            name,
                            detectorName,
                            startTime,
                            endTime,
                            timeGrain,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DetectorResponseInner>> getHostingEnvironmentDetectorResponseWithResponseAsync(
        String resourceGroupName,
        String name,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getHostingEnvironmentDetectorResponse(
                this.client.getEndpoint(),
                resourceGroupName,
                name,
                detectorName,
                startTime,
                endTime,
                timeGrain,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DetectorResponseInner> getHostingEnvironmentDetectorResponseAsync(
        String resourceGroupName,
        String name,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        return getHostingEnvironmentDetectorResponseWithResponseAsync(
                resourceGroupName, name, detectorName, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DetectorResponseInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name.
     * @param detectorName Detector Resource Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DetectorResponseInner> getHostingEnvironmentDetectorResponseAsync(
        String resourceGroupName, String name, String detectorName) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return getHostingEnvironmentDetectorResponseWithResponseAsync(
                resourceGroupName, name, detectorName, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DetectorResponseInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name.
     * @param detectorName Detector Resource Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DetectorResponseInner getHostingEnvironmentDetectorResponse(
        String resourceGroupName, String name, String detectorName) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return getHostingEnvironmentDetectorResponseAsync(
                resourceGroupName, name, detectorName, startTime, endTime, timeGrain)
            .block();
    }

    /**
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DetectorResponseInner> getHostingEnvironmentDetectorResponseWithResponse(
        String resourceGroupName,
        String name,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        return getHostingEnvironmentDetectorResponseWithResponseAsync(
                resourceGroupName, name, detectorName, startTime, endTime, timeGrain, context)
            .block();
    }

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listSiteDetectorResponsesSinglePageAsync(
        String resourceGroupName, String siteName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listSiteDetectorResponses(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<DetectorResponseInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listSiteDetectorResponsesSinglePageAsync(
        String resourceGroupName, String siteName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteDetectorResponses(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DetectorResponseInner> listSiteDetectorResponsesAsync(String resourceGroupName, String siteName) {
        return new PagedFlux<>(
            () -> listSiteDetectorResponsesSinglePageAsync(resourceGroupName, siteName),
            nextLink -> listSiteDetectorResponsesNextSinglePageAsync(nextLink));
    }

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DetectorResponseInner> listSiteDetectorResponsesAsync(
        String resourceGroupName, String siteName, Context context) {
        return new PagedFlux<>(
            () -> listSiteDetectorResponsesSinglePageAsync(resourceGroupName, siteName, context),
            nextLink -> listSiteDetectorResponsesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DetectorResponseInner> listSiteDetectorResponses(String resourceGroupName, String siteName) {
        return new PagedIterable<>(listSiteDetectorResponsesAsync(resourceGroupName, siteName));
    }

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DetectorResponseInner> listSiteDetectorResponses(
        String resourceGroupName, String siteName, Context context) {
        return new PagedIterable<>(listSiteDetectorResponsesAsync(resourceGroupName, siteName, context));
    }

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DetectorResponseInner>> getSiteDetectorResponseWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getSiteDetectorResponse(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            detectorName,
                            startTime,
                            endTime,
                            timeGrain,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DetectorResponseInner>> getSiteDetectorResponseWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getSiteDetectorResponse(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                detectorName,
                startTime,
                endTime,
                timeGrain,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DetectorResponseInner> getSiteDetectorResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        return getSiteDetectorResponseWithResponseAsync(
                resourceGroupName, siteName, detectorName, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DetectorResponseInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DetectorResponseInner> getSiteDetectorResponseAsync(
        String resourceGroupName, String siteName, String detectorName) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return getSiteDetectorResponseWithResponseAsync(
                resourceGroupName, siteName, detectorName, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DetectorResponseInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DetectorResponseInner getSiteDetectorResponse(
        String resourceGroupName, String siteName, String detectorName) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return getSiteDetectorResponseAsync(resourceGroupName, siteName, detectorName, startTime, endTime, timeGrain)
            .block();
    }

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DetectorResponseInner> getSiteDetectorResponseWithResponse(
        String resourceGroupName,
        String siteName,
        String detectorName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        return getSiteDetectorResponseWithResponseAsync(
                resourceGroupName, siteName, detectorName, startTime, endTime, timeGrain, context)
            .block();
    }

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSinglePageAsync(
        String resourceGroupName, String siteName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listSiteDiagnosticCategories(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<DiagnosticCategoryInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSinglePageAsync(
        String resourceGroupName, String siteName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteDiagnosticCategories(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DiagnosticCategoryInner> listSiteDiagnosticCategoriesAsync(
        String resourceGroupName, String siteName) {
        return new PagedFlux<>(
            () -> listSiteDiagnosticCategoriesSinglePageAsync(resourceGroupName, siteName),
            nextLink -> listSiteDiagnosticCategoriesNextSinglePageAsync(nextLink));
    }

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DiagnosticCategoryInner> listSiteDiagnosticCategoriesAsync(
        String resourceGroupName, String siteName, Context context) {
        return new PagedFlux<>(
            () -> listSiteDiagnosticCategoriesSinglePageAsync(resourceGroupName, siteName, context),
            nextLink -> listSiteDiagnosticCategoriesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiagnosticCategoryInner> listSiteDiagnosticCategories(
        String resourceGroupName, String siteName) {
        return new PagedIterable<>(listSiteDiagnosticCategoriesAsync(resourceGroupName, siteName));
    }

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiagnosticCategoryInner> listSiteDiagnosticCategories(
        String resourceGroupName, String siteName, Context context) {
        return new PagedIterable<>(listSiteDiagnosticCategoriesAsync(resourceGroupName, siteName, context));
    }

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DiagnosticCategoryInner>> getSiteDiagnosticCategoryWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getSiteDiagnosticCategory(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            diagnosticCategory,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiagnosticCategoryInner>> getSiteDiagnosticCategoryWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getSiteDiagnosticCategory(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                diagnosticCategory,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiagnosticCategoryInner> getSiteDiagnosticCategoryAsync(
        String resourceGroupName, String siteName, String diagnosticCategory) {
        return getSiteDiagnosticCategoryWithResponseAsync(resourceGroupName, siteName, diagnosticCategory)
            .flatMap(
                (Response<DiagnosticCategoryInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiagnosticCategoryInner getSiteDiagnosticCategory(
        String resourceGroupName, String siteName, String diagnosticCategory) {
        return getSiteDiagnosticCategoryAsync(resourceGroupName, siteName, diagnosticCategory).block();
    }

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DiagnosticCategoryInner> getSiteDiagnosticCategoryWithResponse(
        String resourceGroupName, String siteName, String diagnosticCategory, Context context) {
        return getSiteDiagnosticCategoryWithResponseAsync(resourceGroupName, siteName, diagnosticCategory, context)
            .block();
    }

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AnalysisDefinitionInner>> listSiteAnalysesSinglePageAsync(
        String resourceGroupName, String siteName, String diagnosticCategory) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listSiteAnalyses(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            diagnosticCategory,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<AnalysisDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AnalysisDefinitionInner>> listSiteAnalysesSinglePageAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteAnalyses(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                diagnosticCategory,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnalysisDefinitionInner> listSiteAnalysesAsync(
        String resourceGroupName, String siteName, String diagnosticCategory) {
        return new PagedFlux<>(
            () -> listSiteAnalysesSinglePageAsync(resourceGroupName, siteName, diagnosticCategory),
            nextLink -> listSiteAnalysesNextSinglePageAsync(nextLink));
    }

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<AnalysisDefinitionInner> listSiteAnalysesAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, Context context) {
        return new PagedFlux<>(
            () -> listSiteAnalysesSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, context),
            nextLink -> listSiteAnalysesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnalysisDefinitionInner> listSiteAnalyses(
        String resourceGroupName, String siteName, String diagnosticCategory) {
        return new PagedIterable<>(listSiteAnalysesAsync(resourceGroupName, siteName, diagnosticCategory));
    }

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnalysisDefinitionInner> listSiteAnalyses(
        String resourceGroupName, String siteName, String diagnosticCategory, Context context) {
        return new PagedIterable<>(listSiteAnalysesAsync(resourceGroupName, siteName, diagnosticCategory, context));
    }

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalysisDefinitionInner>> getSiteAnalysisWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (analysisName == null) {
            return Mono.error(new IllegalArgumentException("Parameter analysisName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getSiteAnalysis(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            diagnosticCategory,
                            analysisName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AnalysisDefinitionInner>> getSiteAnalysisWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (analysisName == null) {
            return Mono.error(new IllegalArgumentException("Parameter analysisName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getSiteAnalysis(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                diagnosticCategory,
                analysisName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalysisDefinitionInner> getSiteAnalysisAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        return getSiteAnalysisWithResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName)
            .flatMap(
                (Response<AnalysisDefinitionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalysisDefinitionInner getSiteAnalysis(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        return getSiteAnalysisAsync(resourceGroupName, siteName, diagnosticCategory, analysisName).block();
    }

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalysisDefinitionInner> getSiteAnalysisWithResponse(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, Context context) {
        return getSiteAnalysisWithResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, context)
            .block();
    }

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DiagnosticAnalysisInner>> executeSiteAnalysisWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (analysisName == null) {
            return Mono.error(new IllegalArgumentException("Parameter analysisName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .executeSiteAnalysis(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            diagnosticCategory,
                            analysisName,
                            startTime,
                            endTime,
                            timeGrain,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiagnosticAnalysisInner>> executeSiteAnalysisWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (analysisName == null) {
            return Mono.error(new IllegalArgumentException("Parameter analysisName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .executeSiteAnalysis(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                diagnosticCategory,
                analysisName,
                startTime,
                endTime,
                timeGrain,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiagnosticAnalysisInner> executeSiteAnalysisAsync(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        return executeSiteAnalysisWithResponseAsync(
                resourceGroupName, siteName, diagnosticCategory, analysisName, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DiagnosticAnalysisInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiagnosticAnalysisInner> executeSiteAnalysisAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return executeSiteAnalysisWithResponseAsync(
                resourceGroupName, siteName, diagnosticCategory, analysisName, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DiagnosticAnalysisInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiagnosticAnalysisInner executeSiteAnalysis(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return executeSiteAnalysisAsync(
                resourceGroupName, siteName, diagnosticCategory, analysisName, startTime, endTime, timeGrain)
            .block();
    }

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DiagnosticAnalysisInner> executeSiteAnalysisWithResponse(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        return executeSiteAnalysisWithResponseAsync(
                resourceGroupName, siteName, diagnosticCategory, analysisName, startTime, endTime, timeGrain, context)
            .block();
    }

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorDefinitionResourceInner>> listSiteDetectorsSinglePageAsync(
        String resourceGroupName, String siteName, String diagnosticCategory) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listSiteDetectors(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            diagnosticCategory,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<DetectorDefinitionResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorDefinitionResourceInner>> listSiteDetectorsSinglePageAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteDetectors(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                diagnosticCategory,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DetectorDefinitionResourceInner> listSiteDetectorsAsync(
        String resourceGroupName, String siteName, String diagnosticCategory) {
        return new PagedFlux<>(
            () -> listSiteDetectorsSinglePageAsync(resourceGroupName, siteName, diagnosticCategory),
            nextLink -> listSiteDetectorsNextSinglePageAsync(nextLink));
    }

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DetectorDefinitionResourceInner> listSiteDetectorsAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, Context context) {
        return new PagedFlux<>(
            () -> listSiteDetectorsSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, context),
            nextLink -> listSiteDetectorsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DetectorDefinitionResourceInner> listSiteDetectors(
        String resourceGroupName, String siteName, String diagnosticCategory) {
        return new PagedIterable<>(listSiteDetectorsAsync(resourceGroupName, siteName, diagnosticCategory));
    }

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DetectorDefinitionResourceInner> listSiteDetectors(
        String resourceGroupName, String siteName, String diagnosticCategory, Context context) {
        return new PagedIterable<>(listSiteDetectorsAsync(resourceGroupName, siteName, diagnosticCategory, context));
    }

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DetectorDefinitionResourceInner>> getSiteDetectorWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getSiteDetector(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            diagnosticCategory,
                            detectorName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DetectorDefinitionResourceInner>> getSiteDetectorWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getSiteDetector(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                diagnosticCategory,
                detectorName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DetectorDefinitionResourceInner> getSiteDetectorAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName) {
        return getSiteDetectorWithResponseAsync(resourceGroupName, siteName, diagnosticCategory, detectorName)
            .flatMap(
                (Response<DetectorDefinitionResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DetectorDefinitionResourceInner getSiteDetector(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName) {
        return getSiteDetectorAsync(resourceGroupName, siteName, diagnosticCategory, detectorName).block();
    }

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DetectorDefinitionResourceInner> getSiteDetectorWithResponse(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, Context context) {
        return getSiteDetectorWithResponseAsync(resourceGroupName, siteName, diagnosticCategory, detectorName, context)
            .block();
    }

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DiagnosticDetectorResponseInner>> executeSiteDetectorWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .executeSiteDetector(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            detectorName,
                            diagnosticCategory,
                            startTime,
                            endTime,
                            timeGrain,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiagnosticDetectorResponseInner>> executeSiteDetectorWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .executeSiteDetector(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                detectorName,
                diagnosticCategory,
                startTime,
                endTime,
                timeGrain,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiagnosticDetectorResponseInner> executeSiteDetectorAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        return executeSiteDetectorWithResponseAsync(
                resourceGroupName, siteName, detectorName, diagnosticCategory, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DiagnosticDetectorResponseInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiagnosticDetectorResponseInner> executeSiteDetectorAsync(
        String resourceGroupName, String siteName, String detectorName, String diagnosticCategory) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return executeSiteDetectorWithResponseAsync(
                resourceGroupName, siteName, detectorName, diagnosticCategory, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DiagnosticDetectorResponseInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiagnosticDetectorResponseInner executeSiteDetector(
        String resourceGroupName, String siteName, String detectorName, String diagnosticCategory) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return executeSiteDetectorAsync(
                resourceGroupName, siteName, detectorName, diagnosticCategory, startTime, endTime, timeGrain)
            .block();
    }

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DiagnosticDetectorResponseInner> executeSiteDetectorWithResponse(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        return executeSiteDetectorWithResponseAsync(
                resourceGroupName, siteName, detectorName, diagnosticCategory, startTime, endTime, timeGrain, context)
            .block();
    }

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listSiteDetectorResponsesSlotSinglePageAsync(
        String resourceGroupName, String siteName, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listSiteDetectorResponsesSlot(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            slot,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<DetectorResponseInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listSiteDetectorResponsesSlotSinglePageAsync(
        String resourceGroupName, String siteName, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteDetectorResponsesSlot(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                slot,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DetectorResponseInner> listSiteDetectorResponsesSlotAsync(
        String resourceGroupName, String siteName, String slot) {
        return new PagedFlux<>(
            () -> listSiteDetectorResponsesSlotSinglePageAsync(resourceGroupName, siteName, slot),
            nextLink -> listSiteDetectorResponsesSlotNextSinglePageAsync(nextLink));
    }

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DetectorResponseInner> listSiteDetectorResponsesSlotAsync(
        String resourceGroupName, String siteName, String slot, Context context) {
        return new PagedFlux<>(
            () -> listSiteDetectorResponsesSlotSinglePageAsync(resourceGroupName, siteName, slot, context),
            nextLink -> listSiteDetectorResponsesSlotNextSinglePageAsync(nextLink, context));
    }

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DetectorResponseInner> listSiteDetectorResponsesSlot(
        String resourceGroupName, String siteName, String slot) {
        return new PagedIterable<>(listSiteDetectorResponsesSlotAsync(resourceGroupName, siteName, slot));
    }

    /**
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DetectorResponseInner> listSiteDetectorResponsesSlot(
        String resourceGroupName, String siteName, String slot, Context context) {
        return new PagedIterable<>(listSiteDetectorResponsesSlotAsync(resourceGroupName, siteName, slot, context));
    }

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DetectorResponseInner>> getSiteDetectorResponseSlotWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getSiteDetectorResponseSlot(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            detectorName,
                            slot,
                            startTime,
                            endTime,
                            timeGrain,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DetectorResponseInner>> getSiteDetectorResponseSlotWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getSiteDetectorResponseSlot(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                detectorName,
                slot,
                startTime,
                endTime,
                timeGrain,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DetectorResponseInner> getSiteDetectorResponseSlotAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        return getSiteDetectorResponseSlotWithResponseAsync(
                resourceGroupName, siteName, detectorName, slot, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DetectorResponseInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DetectorResponseInner> getSiteDetectorResponseSlotAsync(
        String resourceGroupName, String siteName, String detectorName, String slot) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return getSiteDetectorResponseSlotWithResponseAsync(
                resourceGroupName, siteName, detectorName, slot, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DetectorResponseInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DetectorResponseInner getSiteDetectorResponseSlot(
        String resourceGroupName, String siteName, String detectorName, String slot) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return getSiteDetectorResponseSlotAsync(
                resourceGroupName, siteName, detectorName, slot, startTime, endTime, timeGrain)
            .block();
    }

    /**
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Detector along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DetectorResponseInner> getSiteDetectorResponseSlotWithResponse(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        return getSiteDetectorResponseSlotWithResponseAsync(
                resourceGroupName, siteName, detectorName, slot, startTime, endTime, timeGrain, context)
            .block();
    }

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotSinglePageAsync(
        String resourceGroupName, String siteName, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listSiteDiagnosticCategoriesSlot(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            slot,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<DiagnosticCategoryInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotSinglePageAsync(
        String resourceGroupName, String siteName, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteDiagnosticCategoriesSlot(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                slot,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DiagnosticCategoryInner> listSiteDiagnosticCategoriesSlotAsync(
        String resourceGroupName, String siteName, String slot) {
        return new PagedFlux<>(
            () -> listSiteDiagnosticCategoriesSlotSinglePageAsync(resourceGroupName, siteName, slot),
            nextLink -> listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextLink));
    }

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DiagnosticCategoryInner> listSiteDiagnosticCategoriesSlotAsync(
        String resourceGroupName, String siteName, String slot, Context context) {
        return new PagedFlux<>(
            () -> listSiteDiagnosticCategoriesSlotSinglePageAsync(resourceGroupName, siteName, slot, context),
            nextLink -> listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextLink, context));
    }

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiagnosticCategoryInner> listSiteDiagnosticCategoriesSlot(
        String resourceGroupName, String siteName, String slot) {
        return new PagedIterable<>(listSiteDiagnosticCategoriesSlotAsync(resourceGroupName, siteName, slot));
    }

    /**
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiagnosticCategoryInner> listSiteDiagnosticCategoriesSlot(
        String resourceGroupName, String siteName, String slot, Context context) {
        return new PagedIterable<>(listSiteDiagnosticCategoriesSlotAsync(resourceGroupName, siteName, slot, context));
    }

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DiagnosticCategoryInner>> getSiteDiagnosticCategorySlotWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getSiteDiagnosticCategorySlot(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            diagnosticCategory,
                            slot,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiagnosticCategoryInner>> getSiteDiagnosticCategorySlotWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getSiteDiagnosticCategorySlot(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                diagnosticCategory,
                slot,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiagnosticCategoryInner> getSiteDiagnosticCategorySlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return getSiteDiagnosticCategorySlotWithResponseAsync(resourceGroupName, siteName, diagnosticCategory, slot)
            .flatMap(
                (Response<DiagnosticCategoryInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiagnosticCategoryInner getSiteDiagnosticCategorySlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return getSiteDiagnosticCategorySlotAsync(resourceGroupName, siteName, diagnosticCategory, slot).block();
    }

    /**
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing detector definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DiagnosticCategoryInner> getSiteDiagnosticCategorySlotWithResponse(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot, Context context) {
        return getSiteDiagnosticCategorySlotWithResponseAsync(
                resourceGroupName, siteName, diagnosticCategory, slot, context)
            .block();
    }

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AnalysisDefinitionInner>> listSiteAnalysesSlotSinglePageAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listSiteAnalysesSlot(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            diagnosticCategory,
                            slot,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<AnalysisDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AnalysisDefinitionInner>> listSiteAnalysesSlotSinglePageAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteAnalysesSlot(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                diagnosticCategory,
                slot,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnalysisDefinitionInner> listSiteAnalysesSlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return new PagedFlux<>(
            () -> listSiteAnalysesSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot),
            nextLink -> listSiteAnalysesSlotNextSinglePageAsync(nextLink));
    }

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<AnalysisDefinitionInner> listSiteAnalysesSlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot, Context context) {
        return new PagedFlux<>(
            () -> listSiteAnalysesSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot, context),
            nextLink -> listSiteAnalysesSlotNextSinglePageAsync(nextLink, context));
    }

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnalysisDefinitionInner> listSiteAnalysesSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return new PagedIterable<>(listSiteAnalysesSlotAsync(resourceGroupName, siteName, diagnosticCategory, slot));
    }

    /**
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnalysisDefinitionInner> listSiteAnalysesSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot, Context context) {
        return new PagedIterable<>(
            listSiteAnalysesSlotAsync(resourceGroupName, siteName, diagnosticCategory, slot, context));
    }

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @param slot Slot - optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalysisDefinitionInner>> getSiteAnalysisSlotWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (analysisName == null) {
            return Mono.error(new IllegalArgumentException("Parameter analysisName is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getSiteAnalysisSlot(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            diagnosticCategory,
                            analysisName,
                            slot,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @param slot Slot - optional.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AnalysisDefinitionInner>> getSiteAnalysisSlotWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        String slot,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (analysisName == null) {
            return Mono.error(new IllegalArgumentException("Parameter analysisName is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getSiteAnalysisSlot(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                diagnosticCategory,
                analysisName,
                slot,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @param slot Slot - optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalysisDefinitionInner> getSiteAnalysisSlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        return getSiteAnalysisSlotWithResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot)
            .flatMap(
                (Response<AnalysisDefinitionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @param slot Slot - optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalysisDefinitionInner getSiteAnalysisSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        return getSiteAnalysisSlotAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot).block();
    }

    /**
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param analysisName Analysis Name.
     * @param slot Slot - optional.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of Analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalysisDefinitionInner> getSiteAnalysisSlotWithResponse(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        String slot,
        Context context) {
        return getSiteAnalysisSlotWithResponseAsync(
                resourceGroupName, siteName, diagnosticCategory, analysisName, slot, context)
            .block();
    }

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DiagnosticAnalysisInner>> executeSiteAnalysisSlotWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (analysisName == null) {
            return Mono.error(new IllegalArgumentException("Parameter analysisName is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .executeSiteAnalysisSlot(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            diagnosticCategory,
                            analysisName,
                            slot,
                            startTime,
                            endTime,
                            timeGrain,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiagnosticAnalysisInner>> executeSiteAnalysisSlotWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (analysisName == null) {
            return Mono.error(new IllegalArgumentException("Parameter analysisName is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .executeSiteAnalysisSlot(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                diagnosticCategory,
                analysisName,
                slot,
                startTime,
                endTime,
                timeGrain,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiagnosticAnalysisInner> executeSiteAnalysisSlotAsync(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        return executeSiteAnalysisSlotWithResponseAsync(
                resourceGroupName, siteName, diagnosticCategory, analysisName, slot, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DiagnosticAnalysisInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiagnosticAnalysisInner> executeSiteAnalysisSlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return executeSiteAnalysisSlotWithResponseAsync(
                resourceGroupName, siteName, diagnosticCategory, analysisName, slot, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DiagnosticAnalysisInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiagnosticAnalysisInner executeSiteAnalysisSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return executeSiteAnalysisSlotAsync(
                resourceGroupName, siteName, diagnosticCategory, analysisName, slot, startTime, endTime, timeGrain)
            .block();
    }

    /**
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Category Name.
     * @param analysisName Analysis Resource Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a diagnostic analysis done on an application along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DiagnosticAnalysisInner> executeSiteAnalysisSlotWithResponse(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String analysisName,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        return executeSiteAnalysisSlotWithResponseAsync(
                resourceGroupName,
                siteName,
                diagnosticCategory,
                analysisName,
                slot,
                startTime,
                endTime,
                timeGrain,
                context)
            .block();
    }

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorDefinitionResourceInner>> listSiteDetectorsSlotSinglePageAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listSiteDetectorsSlot(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            diagnosticCategory,
                            slot,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<DetectorDefinitionResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorDefinitionResourceInner>> listSiteDetectorsSlotSinglePageAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteDetectorsSlot(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                diagnosticCategory,
                slot,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DetectorDefinitionResourceInner> listSiteDetectorsSlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return new PagedFlux<>(
            () -> listSiteDetectorsSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot),
            nextLink -> listSiteDetectorsSlotNextSinglePageAsync(nextLink));
    }

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DetectorDefinitionResourceInner> listSiteDetectorsSlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot, Context context) {
        return new PagedFlux<>(
            () -> listSiteDetectorsSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot, context),
            nextLink -> listSiteDetectorsSlotNextSinglePageAsync(nextLink, context));
    }

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DetectorDefinitionResourceInner> listSiteDetectorsSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return new PagedIterable<>(listSiteDetectorsSlotAsync(resourceGroupName, siteName, diagnosticCategory, slot));
    }

    /**
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DetectorDefinitionResourceInner> listSiteDetectorsSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String slot, Context context) {
        return new PagedIterable<>(
            listSiteDetectorsSlotAsync(resourceGroupName, siteName, diagnosticCategory, slot, context));
    }

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DetectorDefinitionResourceInner>> getSiteDetectorSlotWithResponseAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getSiteDetectorSlot(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            diagnosticCategory,
                            detectorName,
                            slot,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DetectorDefinitionResourceInner>> getSiteDetectorSlotWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String detectorName,
        String slot,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getSiteDetectorSlot(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                diagnosticCategory,
                detectorName,
                slot,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DetectorDefinitionResourceInner> getSiteDetectorSlotAsync(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot) {
        return getSiteDetectorSlotWithResponseAsync(resourceGroupName, siteName, diagnosticCategory, detectorName, slot)
            .flatMap(
                (Response<DetectorDefinitionResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DetectorDefinitionResourceInner getSiteDetectorSlot(
        String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot) {
        return getSiteDetectorSlotAsync(resourceGroupName, siteName, diagnosticCategory, detectorName, slot).block();
    }

    /**
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param diagnosticCategory Diagnostic Category.
     * @param detectorName Detector Name.
     * @param slot Slot Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aRM resource for a detector definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DetectorDefinitionResourceInner> getSiteDetectorSlotWithResponse(
        String resourceGroupName,
        String siteName,
        String diagnosticCategory,
        String detectorName,
        String slot,
        Context context) {
        return getSiteDetectorSlotWithResponseAsync(
                resourceGroupName, siteName, diagnosticCategory, detectorName, slot, context)
            .block();
    }

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DiagnosticDetectorResponseInner>> executeSiteDetectorSlotWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .executeSiteDetectorSlot(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            siteName,
                            detectorName,
                            diagnosticCategory,
                            slot,
                            startTime,
                            endTime,
                            timeGrain,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiagnosticDetectorResponseInner>> executeSiteDetectorSlotWithResponseAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        if (diagnosticCategory == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .executeSiteDetectorSlot(
                this.client.getEndpoint(),
                resourceGroupName,
                siteName,
                detectorName,
                diagnosticCategory,
                slot,
                startTime,
                endTime,
                timeGrain,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiagnosticDetectorResponseInner> executeSiteDetectorSlotAsync(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain) {
        return executeSiteDetectorSlotWithResponseAsync(
                resourceGroupName, siteName, detectorName, diagnosticCategory, slot, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DiagnosticDetectorResponseInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiagnosticDetectorResponseInner> executeSiteDetectorSlotAsync(
        String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return executeSiteDetectorSlotWithResponseAsync(
                resourceGroupName, siteName, detectorName, diagnosticCategory, slot, startTime, endTime, timeGrain)
            .flatMap(
                (Response<DiagnosticDetectorResponseInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param slot Slot Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiagnosticDetectorResponseInner executeSiteDetectorSlot(
        String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot) {
        final OffsetDateTime startTime = null;
        final OffsetDateTime endTime = null;
        final String timeGrain = null;
        return executeSiteDetectorSlotAsync(
                resourceGroupName, siteName, detectorName, diagnosticCategory, slot, startTime, endTime, timeGrain)
            .block();
    }

    /**
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name.
     * @param detectorName Detector Resource Name.
     * @param diagnosticCategory Category Name.
     * @param slot Slot Name.
     * @param startTime Start Time.
     * @param endTime End Time.
     * @param timeGrain Time Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Response from Diagnostic Detectors along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DiagnosticDetectorResponseInner> executeSiteDetectorSlotWithResponse(
        String resourceGroupName,
        String siteName,
        String detectorName,
        String diagnosticCategory,
        String slot,
        OffsetDateTime startTime,
        OffsetDateTime endTime,
        String timeGrain,
        Context context) {
        return executeSiteDetectorSlotWithResponseAsync(
                resourceGroupName,
                siteName,
                detectorName,
                diagnosticCategory,
                slot,
                startTime,
                endTime,
                timeGrain,
                context)
            .block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listHostingEnvironmentDetectorResponsesNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listHostingEnvironmentDetectorResponsesNext(
                            nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DetectorResponseInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listHostingEnvironmentDetectorResponsesNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listHostingEnvironmentDetectorResponsesNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listSiteDetectorResponsesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listSiteDetectorResponsesNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DetectorResponseInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listSiteDetectorResponsesNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteDetectorResponsesNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.listSiteDiagnosticCategoriesNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DiagnosticCategoryInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteDiagnosticCategoriesNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AnalysisDefinitionInner>> listSiteAnalysesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSiteAnalysesNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<AnalysisDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AnalysisDefinitionInner>> listSiteAnalysesNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteAnalysesNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorDefinitionResourceInner>> listSiteDetectorsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSiteDetectorsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DetectorDefinitionResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorDefinitionResourceInner>> listSiteDetectorsNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteDetectorsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listSiteDetectorResponsesSlotNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.listSiteDetectorResponsesSlotNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DetectorResponseInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of detector responses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorResponseInner>> listSiteDetectorResponsesSlotNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteDetectorResponsesSlotNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.listSiteDiagnosticCategoriesSlotNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DiagnosticCategoryInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Categories along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteDiagnosticCategoriesSlotNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AnalysisDefinitionInner>> listSiteAnalysesSlotNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listSiteAnalysesSlotNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<AnalysisDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Analyses along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AnalysisDefinitionInner>> listSiteAnalysesSlotNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteAnalysesSlotNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorDefinitionResourceInner>> listSiteDetectorsSlotNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listSiteDetectorsSlotNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DetectorDefinitionResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Diagnostic Detectors along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DetectorDefinitionResourceInner>> listSiteDetectorsSlotNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSiteDetectorsSlotNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
