// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** VnetGateway resource specific properties. */
@Fluent
public final class VnetGatewayProperties {
    /*
     * The Virtual Network name.
     */
    @JsonProperty(value = "vnetName")
    private String vnetName;

    /*
     * The URI where the VPN package can be downloaded.
     */
    @JsonProperty(value = "vpnPackageUri", required = true)
    private String vpnPackageUri;

    /**
     * Get the vnetName property: The Virtual Network name.
     *
     * @return the vnetName value.
     */
    public String vnetName() {
        return this.vnetName;
    }

    /**
     * Set the vnetName property: The Virtual Network name.
     *
     * @param vnetName the vnetName value to set.
     * @return the VnetGatewayProperties object itself.
     */
    public VnetGatewayProperties withVnetName(String vnetName) {
        this.vnetName = vnetName;
        return this;
    }

    /**
     * Get the vpnPackageUri property: The URI where the VPN package can be downloaded.
     *
     * @return the vpnPackageUri value.
     */
    public String vpnPackageUri() {
        return this.vpnPackageUri;
    }

    /**
     * Set the vpnPackageUri property: The URI where the VPN package can be downloaded.
     *
     * @param vpnPackageUri the vpnPackageUri value to set.
     * @return the VnetGatewayProperties object itself.
     */
    public VnetGatewayProperties withVpnPackageUri(String vpnPackageUri) {
        this.vpnPackageUri = vpnPackageUri;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vpnPackageUri() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property vpnPackageUri in model VnetGatewayProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VnetGatewayProperties.class);
}
