/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ResourceSkuZoneDetails;
import java.io.IOException;
import java.util.List;

public final class ResourceSkuLocationInfo
implements JsonSerializable<ResourceSkuLocationInfo> {
    private String location;
    private List<String> zones;
    private List<ResourceSkuZoneDetails> zoneDetails;

    public String location() {
        return this.location;
    }

    public ResourceSkuLocationInfo withLocation(String location) {
        this.location = location;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public ResourceSkuLocationInfo withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public List<ResourceSkuZoneDetails> zoneDetails() {
        return this.zoneDetails;
    }

    public ResourceSkuLocationInfo withZoneDetails(List<ResourceSkuZoneDetails> zoneDetails) {
        this.zoneDetails = zoneDetails;
        return this;
    }

    public void validate() {
        if (this.zoneDetails() != null) {
            this.zoneDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("zoneDetails", this.zoneDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceSkuLocationInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceSkuLocationInfo)jsonReader.readObject(reader -> {
            ResourceSkuLocationInfo deserializedResourceSkuLocationInfo = new ResourceSkuLocationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedResourceSkuLocationInfo.location = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedResourceSkuLocationInfo.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("zoneDetails".equals(fieldName)) {
                    List zoneDetails;
                    deserializedResourceSkuLocationInfo.zoneDetails = zoneDetails = reader.readArray(reader1 -> ResourceSkuZoneDetails.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceSkuLocationInfo;
        });
    }
}

