/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class GatewayApiRoute
implements JsonSerializable<GatewayApiRoute> {
    private String title;
    private String description;
    private String uri;
    private Boolean ssoEnabled;
    private Boolean tokenRelay;
    private List<String> predicates;
    private List<String> filters;
    private Integer order;
    private List<String> tags;

    public String title() {
        return this.title;
    }

    public GatewayApiRoute withTitle(String title) {
        this.title = title;
        return this;
    }

    public String description() {
        return this.description;
    }

    public GatewayApiRoute withDescription(String description) {
        this.description = description;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public GatewayApiRoute withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public Boolean ssoEnabled() {
        return this.ssoEnabled;
    }

    public GatewayApiRoute withSsoEnabled(Boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
        return this;
    }

    public Boolean tokenRelay() {
        return this.tokenRelay;
    }

    public GatewayApiRoute withTokenRelay(Boolean tokenRelay) {
        this.tokenRelay = tokenRelay;
        return this;
    }

    public List<String> predicates() {
        return this.predicates;
    }

    public GatewayApiRoute withPredicates(List<String> predicates) {
        this.predicates = predicates;
        return this;
    }

    public List<String> filters() {
        return this.filters;
    }

    public GatewayApiRoute withFilters(List<String> filters) {
        this.filters = filters;
        return this;
    }

    public Integer order() {
        return this.order;
    }

    public GatewayApiRoute withOrder(Integer order) {
        this.order = order;
        return this;
    }

    public List<String> tags() {
        return this.tags;
    }

    public GatewayApiRoute withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeBooleanField("ssoEnabled", this.ssoEnabled);
        jsonWriter.writeBooleanField("tokenRelay", this.tokenRelay);
        jsonWriter.writeArrayField("predicates", this.predicates, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("order", (Number)this.order);
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static GatewayApiRoute fromJson(JsonReader jsonReader) throws IOException {
        return (GatewayApiRoute)jsonReader.readObject(reader -> {
            GatewayApiRoute deserializedGatewayApiRoute = new GatewayApiRoute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("title".equals(fieldName)) {
                    deserializedGatewayApiRoute.title = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGatewayApiRoute.description = reader.getString();
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedGatewayApiRoute.uri = reader.getString();
                    continue;
                }
                if ("ssoEnabled".equals(fieldName)) {
                    deserializedGatewayApiRoute.ssoEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("tokenRelay".equals(fieldName)) {
                    deserializedGatewayApiRoute.tokenRelay = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("predicates".equals(fieldName)) {
                    List predicates;
                    deserializedGatewayApiRoute.predicates = predicates = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    List filters;
                    deserializedGatewayApiRoute.filters = filters = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("order".equals(fieldName)) {
                    deserializedGatewayApiRoute.order = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    List tags;
                    deserializedGatewayApiRoute.tags = tags = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGatewayApiRoute;
        });
    }
}

