/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.AppResourceProvisioningState;
import com.azure.resourcemanager.appplatform.models.AppVNetAddons;
import com.azure.resourcemanager.appplatform.models.CustomPersistentDiskResource;
import com.azure.resourcemanager.appplatform.models.IngressSettings;
import com.azure.resourcemanager.appplatform.models.LoadedCertificate;
import com.azure.resourcemanager.appplatform.models.PersistentDisk;
import com.azure.resourcemanager.appplatform.models.TemporaryDisk;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AppResourceProperties
implements JsonSerializable<AppResourceProperties> {
    private Boolean publicProperty;
    private String url;
    private Map<String, Map<String, Object>> addonConfigs;
    private AppResourceProvisioningState provisioningState;
    private String fqdn;
    private Boolean httpsOnly;
    private TemporaryDisk temporaryDisk;
    private PersistentDisk persistentDisk;
    private List<CustomPersistentDiskResource> customPersistentDisks;
    private Boolean enableEndToEndTls;
    private List<LoadedCertificate> loadedCertificates;
    private AppVNetAddons vnetAddons;
    private IngressSettings ingressSettings;

    public Boolean publicProperty() {
        return this.publicProperty;
    }

    public AppResourceProperties withPublicProperty(Boolean publicProperty) {
        this.publicProperty = publicProperty;
        return this;
    }

    public String url() {
        return this.url;
    }

    public Map<String, Map<String, Object>> addonConfigs() {
        return this.addonConfigs;
    }

    public AppResourceProperties withAddonConfigs(Map<String, Map<String, Object>> addonConfigs) {
        this.addonConfigs = addonConfigs;
        return this;
    }

    public AppResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public Boolean httpsOnly() {
        return this.httpsOnly;
    }

    public AppResourceProperties withHttpsOnly(Boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    public TemporaryDisk temporaryDisk() {
        return this.temporaryDisk;
    }

    public AppResourceProperties withTemporaryDisk(TemporaryDisk temporaryDisk) {
        this.temporaryDisk = temporaryDisk;
        return this;
    }

    public PersistentDisk persistentDisk() {
        return this.persistentDisk;
    }

    public AppResourceProperties withPersistentDisk(PersistentDisk persistentDisk) {
        this.persistentDisk = persistentDisk;
        return this;
    }

    public List<CustomPersistentDiskResource> customPersistentDisks() {
        return this.customPersistentDisks;
    }

    public AppResourceProperties withCustomPersistentDisks(List<CustomPersistentDiskResource> customPersistentDisks) {
        this.customPersistentDisks = customPersistentDisks;
        return this;
    }

    public Boolean enableEndToEndTls() {
        return this.enableEndToEndTls;
    }

    public AppResourceProperties withEnableEndToEndTls(Boolean enableEndToEndTls) {
        this.enableEndToEndTls = enableEndToEndTls;
        return this;
    }

    public List<LoadedCertificate> loadedCertificates() {
        return this.loadedCertificates;
    }

    public AppResourceProperties withLoadedCertificates(List<LoadedCertificate> loadedCertificates) {
        this.loadedCertificates = loadedCertificates;
        return this;
    }

    public AppVNetAddons vnetAddons() {
        return this.vnetAddons;
    }

    public AppResourceProperties withVnetAddons(AppVNetAddons vnetAddons) {
        this.vnetAddons = vnetAddons;
        return this;
    }

    public IngressSettings ingressSettings() {
        return this.ingressSettings;
    }

    public AppResourceProperties withIngressSettings(IngressSettings ingressSettings) {
        this.ingressSettings = ingressSettings;
        return this;
    }

    public void validate() {
        if (this.temporaryDisk() != null) {
            this.temporaryDisk().validate();
        }
        if (this.persistentDisk() != null) {
            this.persistentDisk().validate();
        }
        if (this.customPersistentDisks() != null) {
            this.customPersistentDisks().forEach(e -> e.validate());
        }
        if (this.loadedCertificates() != null) {
            this.loadedCertificates().forEach(e -> e.validate());
        }
        if (this.vnetAddons() != null) {
            this.vnetAddons().validate();
        }
        if (this.ingressSettings() != null) {
            this.ingressSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("public", this.publicProperty);
        jsonWriter.writeMapField("addonConfigs", this.addonConfigs, (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeUntyped(element1)));
        jsonWriter.writeBooleanField("httpsOnly", this.httpsOnly);
        jsonWriter.writeJsonField("temporaryDisk", (JsonSerializable)this.temporaryDisk);
        jsonWriter.writeJsonField("persistentDisk", (JsonSerializable)this.persistentDisk);
        jsonWriter.writeArrayField("customPersistentDisks", this.customPersistentDisks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableEndToEndTLS", this.enableEndToEndTls);
        jsonWriter.writeArrayField("loadedCertificates", this.loadedCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("vnetAddons", (JsonSerializable)this.vnetAddons);
        jsonWriter.writeJsonField("ingressSettings", (JsonSerializable)this.ingressSettings);
        return jsonWriter.writeEndObject();
    }

    public static AppResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AppResourceProperties)jsonReader.readObject(reader -> {
            AppResourceProperties deserializedAppResourceProperties = new AppResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("public".equals(fieldName)) {
                    deserializedAppResourceProperties.publicProperty = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedAppResourceProperties.url = reader.getString();
                    continue;
                }
                if ("addonConfigs".equals(fieldName)) {
                    Map addonConfigs;
                    deserializedAppResourceProperties.addonConfigs = addonConfigs = reader.readMap(reader1 -> reader1.readMap(reader2 -> reader2.readUntyped()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAppResourceProperties.provisioningState = AppResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedAppResourceProperties.fqdn = reader.getString();
                    continue;
                }
                if ("httpsOnly".equals(fieldName)) {
                    deserializedAppResourceProperties.httpsOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("temporaryDisk".equals(fieldName)) {
                    deserializedAppResourceProperties.temporaryDisk = TemporaryDisk.fromJson(reader);
                    continue;
                }
                if ("persistentDisk".equals(fieldName)) {
                    deserializedAppResourceProperties.persistentDisk = PersistentDisk.fromJson(reader);
                    continue;
                }
                if ("customPersistentDisks".equals(fieldName)) {
                    List customPersistentDisks;
                    deserializedAppResourceProperties.customPersistentDisks = customPersistentDisks = reader.readArray(reader1 -> CustomPersistentDiskResource.fromJson(reader1));
                    continue;
                }
                if ("enableEndToEndTLS".equals(fieldName)) {
                    deserializedAppResourceProperties.enableEndToEndTls = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("loadedCertificates".equals(fieldName)) {
                    List loadedCertificates;
                    deserializedAppResourceProperties.loadedCertificates = loadedCertificates = reader.readArray(reader1 -> LoadedCertificate.fromJson(reader1));
                    continue;
                }
                if ("vnetAddons".equals(fieldName)) {
                    deserializedAppResourceProperties.vnetAddons = AppVNetAddons.fromJson(reader);
                    continue;
                }
                if ("ingressSettings".equals(fieldName)) {
                    deserializedAppResourceProperties.ingressSettings = IngressSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppResourceProperties;
        });
    }
}

