/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.BuildResultUserSourceInfo;
import com.azure.resourcemanager.appplatform.models.CustomContainerUserSourceInfo;
import com.azure.resourcemanager.appplatform.models.JarUploadedUserSourceInfo;
import com.azure.resourcemanager.appplatform.models.NetCoreZipUploadedUserSourceInfo;
import com.azure.resourcemanager.appplatform.models.SourceUploadedUserSourceInfo;
import com.azure.resourcemanager.appplatform.models.UploadedUserSourceInfo;
import com.azure.resourcemanager.appplatform.models.WarUploadedUserSourceInfo;
import java.io.IOException;

public class UserSourceInfo
implements JsonSerializable<UserSourceInfo> {
    private String type = "UserSourceInfo";
    private String version;

    public String type() {
        return this.type;
    }

    public String version() {
        return this.version;
    }

    public UserSourceInfo withVersion(String version) {
        this.version = version;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    public static UserSourceInfo fromJson(JsonReader jsonReader) throws IOException {
        return (UserSourceInfo)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                UserSourceInfo userSourceInfo;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("UploadedUserSourceInfo".equals(discriminatorValue)) {
                    userSourceInfo = UploadedUserSourceInfo.fromJsonKnownDiscriminator(readerToUse.reset());
                    return userSourceInfo;
                }
                if ("Jar".equals(discriminatorValue)) {
                    userSourceInfo = JarUploadedUserSourceInfo.fromJson(readerToUse.reset());
                    return userSourceInfo;
                }
                if ("War".equals(discriminatorValue)) {
                    userSourceInfo = WarUploadedUserSourceInfo.fromJson(readerToUse.reset());
                    return userSourceInfo;
                }
                if ("Source".equals(discriminatorValue)) {
                    userSourceInfo = SourceUploadedUserSourceInfo.fromJson(readerToUse.reset());
                    return userSourceInfo;
                }
                if ("NetCoreZip".equals(discriminatorValue)) {
                    userSourceInfo = NetCoreZipUploadedUserSourceInfo.fromJson(readerToUse.reset());
                    return userSourceInfo;
                }
                if ("BuildResult".equals(discriminatorValue)) {
                    userSourceInfo = BuildResultUserSourceInfo.fromJson(readerToUse.reset());
                    return userSourceInfo;
                }
                if ("Container".equals(discriminatorValue)) {
                    userSourceInfo = CustomContainerUserSourceInfo.fromJson(readerToUse.reset());
                    return userSourceInfo;
                }
                userSourceInfo = UserSourceInfo.fromJsonKnownDiscriminator(readerToUse.reset());
                return userSourceInfo;
            }
        });
    }

    static UserSourceInfo fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (UserSourceInfo)jsonReader.readObject(reader -> {
            UserSourceInfo deserializedUserSourceInfo = new UserSourceInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedUserSourceInfo.type = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedUserSourceInfo.version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserSourceInfo;
        });
    }
}

