/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.BuildpackProperties;
import java.io.IOException;
import java.util.List;

public final class BuildpacksGroupProperties
implements JsonSerializable<BuildpacksGroupProperties> {
    private String name;
    private List<BuildpackProperties> buildpacks;

    public String name() {
        return this.name;
    }

    public BuildpacksGroupProperties withName(String name) {
        this.name = name;
        return this;
    }

    public List<BuildpackProperties> buildpacks() {
        return this.buildpacks;
    }

    public BuildpacksGroupProperties withBuildpacks(List<BuildpackProperties> buildpacks) {
        this.buildpacks = buildpacks;
        return this;
    }

    public void validate() {
        if (this.buildpacks() != null) {
            this.buildpacks().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("buildpacks", this.buildpacks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BuildpacksGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BuildpacksGroupProperties)jsonReader.readObject(reader -> {
            BuildpacksGroupProperties deserializedBuildpacksGroupProperties = new BuildpacksGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedBuildpacksGroupProperties.name = reader.getString();
                    continue;
                }
                if ("buildpacks".equals(fieldName)) {
                    List buildpacks;
                    deserializedBuildpacksGroupProperties.buildpacks = buildpacks = reader.readArray(reader1 -> BuildpackProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuildpacksGroupProperties;
        });
    }
}

