/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appplatform.fluent.ApiPortalCustomDomainsClient;
import com.azure.resourcemanager.appplatform.fluent.models.ApiPortalCustomDomainResourceInner;
import com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.azure.resourcemanager.appplatform.models.ApiPortalCustomDomainResourceCollection;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ApiPortalCustomDomainsClientImpl
implements ApiPortalCustomDomainsClient {
    private final ApiPortalCustomDomainsService service;
    private final AppPlatformManagementClientImpl client;

    ApiPortalCustomDomainsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = (ApiPortalCustomDomainsService)RestProxy.create(ApiPortalCustomDomainsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ApiPortalCustomDomainResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiPortalName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiPortalName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apiPortalName, domainName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApiPortalCustomDomainResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiPortalName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiPortalName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apiPortalName, domainName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApiPortalCustomDomainResourceInner> getAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, apiPortalName, domainName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ApiPortalCustomDomainResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApiPortalCustomDomainResourceInner> getWithResponse(String resourceGroupName, String serviceName, String apiPortalName, String domainName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serviceName, apiPortalName, domainName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiPortalCustomDomainResourceInner get(String resourceGroupName, String serviceName, String apiPortalName, String domainName) {
        return (ApiPortalCustomDomainResourceInner)((Object)this.getWithResponse(resourceGroupName, serviceName, apiPortalName, domainName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiPortalName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiPortalName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (apiPortalCustomDomainResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiPortalCustomDomainResource is required and cannot be null."));
        }
        apiPortalCustomDomainResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apiPortalName, domainName, apiPortalCustomDomainResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiPortalName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiPortalName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (apiPortalCustomDomainResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiPortalCustomDomainResource is required and cannot be null."));
        }
        apiPortalCustomDomainResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apiPortalName, domainName, apiPortalCustomDomainResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ApiPortalCustomDomainResourceInner>, ApiPortalCustomDomainResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, apiPortalName, domainName, apiPortalCustomDomainResource);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ApiPortalCustomDomainResourceInner.class), (Type)((Object)ApiPortalCustomDomainResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ApiPortalCustomDomainResourceInner>, ApiPortalCustomDomainResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, apiPortalName, domainName, apiPortalCustomDomainResource, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ApiPortalCustomDomainResourceInner.class), (Type)((Object)ApiPortalCustomDomainResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ApiPortalCustomDomainResourceInner>, ApiPortalCustomDomainResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, apiPortalName, domainName, apiPortalCustomDomainResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ApiPortalCustomDomainResourceInner>, ApiPortalCustomDomainResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, apiPortalName, domainName, apiPortalCustomDomainResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApiPortalCustomDomainResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, apiPortalName, domainName, apiPortalCustomDomainResource).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiPortalCustomDomainResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, apiPortalName, domainName, apiPortalCustomDomainResource, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiPortalCustomDomainResourceInner createOrUpdate(String resourceGroupName, String serviceName, String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource) {
        return (ApiPortalCustomDomainResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, apiPortalName, domainName, apiPortalCustomDomainResource).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiPortalCustomDomainResourceInner createOrUpdate(String resourceGroupName, String serviceName, String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource, Context context) {
        return (ApiPortalCustomDomainResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, apiPortalName, domainName, apiPortalCustomDomainResource, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiPortalName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiPortalName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apiPortalName, domainName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiPortalName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiPortalName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apiPortalName, domainName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, apiPortalName, domainName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, apiPortalName, domainName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String apiPortalName, String domainName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, apiPortalName, domainName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String apiPortalName, String domainName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, apiPortalName, domainName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, apiPortalName, domainName).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, apiPortalName, domainName, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String apiPortalName, String domainName) {
        this.deleteAsync(resourceGroupName, serviceName, apiPortalName, domainName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String apiPortalName, String domainName, Context context) {
        this.deleteAsync(resourceGroupName, serviceName, apiPortalName, domainName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiPortalCustomDomainResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String apiPortalName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiPortalName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiPortalName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apiPortalName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiPortalCustomDomainResourceCollection)res.getValue()).value(), ((ApiPortalCustomDomainResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiPortalCustomDomainResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String apiPortalName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiPortalName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiPortalName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apiPortalName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiPortalCustomDomainResourceCollection)res.getValue()).value(), ((ApiPortalCustomDomainResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ApiPortalCustomDomainResourceInner> listAsync(String resourceGroupName, String serviceName, String apiPortalName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, apiPortalName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApiPortalCustomDomainResourceInner> listAsync(String resourceGroupName, String serviceName, String apiPortalName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, apiPortalName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiPortalCustomDomainResourceInner> list(String resourceGroupName, String serviceName, String apiPortalName) {
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, apiPortalName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiPortalCustomDomainResourceInner> list(String resourceGroupName, String serviceName, String apiPortalName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, apiPortalName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiPortalCustomDomainResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiPortalCustomDomainResourceCollection)res.getValue()).value(), ((ApiPortalCustomDomainResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiPortalCustomDomainResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiPortalCustomDomainResourceCollection)res.getValue()).value(), ((ApiPortalCustomDomainResourceCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    public static interface ApiPortalCustomDomainsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apiPortals/{apiPortalName}/domains/{domainName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApiPortalCustomDomainResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="apiPortalName") String var6, @PathParam(value="domainName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apiPortals/{apiPortalName}/domains/{domainName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="apiPortalName") String var6, @PathParam(value="domainName") String var7, @BodyParam(value="application/json") ApiPortalCustomDomainResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apiPortals/{apiPortalName}/domains/{domainName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="apiPortalName") String var6, @PathParam(value="domainName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apiPortals/{apiPortalName}/domains")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApiPortalCustomDomainResourceCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="apiPortalName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApiPortalCustomDomainResourceCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

