/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ApplicationAcceleratorProperties;
import com.azure.resourcemanager.appplatform.models.Sku;
import java.io.IOException;

public final class ApplicationAcceleratorResourceInner
extends ProxyResource {
    private ApplicationAcceleratorProperties properties;
    private Sku sku;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    public ApplicationAcceleratorProperties properties() {
        return this.properties;
    }

    public ApplicationAcceleratorResourceInner withProperties(ApplicationAcceleratorProperties properties) {
        this.properties = properties;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public ApplicationAcceleratorResourceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationAcceleratorResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationAcceleratorResourceInner)((Object)jsonReader.readObject(reader -> {
            ApplicationAcceleratorResourceInner deserializedApplicationAcceleratorResourceInner = new ApplicationAcceleratorResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApplicationAcceleratorResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApplicationAcceleratorResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApplicationAcceleratorResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApplicationAcceleratorResourceInner.properties = ApplicationAcceleratorProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedApplicationAcceleratorResourceInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedApplicationAcceleratorResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationAcceleratorResourceInner;
        }));
    }
}

