/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.azure.resourcemanager.appplatform.models.DeploymentResourceProvisioningState;
import com.azure.resourcemanager.appplatform.models.DeploymentResourceStatus;
import com.azure.resourcemanager.appplatform.models.DeploymentSettings;
import com.azure.resourcemanager.appplatform.models.UserSourceInfo;
import java.io.IOException;
import java.util.List;

public final class DeploymentResourceProperties
implements JsonSerializable<DeploymentResourceProperties> {
    private UserSourceInfo source;
    private DeploymentSettings deploymentSettings;
    private DeploymentResourceProvisioningState provisioningState;
    private DeploymentResourceStatus status;
    private Boolean active;
    private List<DeploymentInstance> instances;

    public UserSourceInfo source() {
        return this.source;
    }

    public DeploymentResourceProperties withSource(UserSourceInfo source) {
        this.source = source;
        return this;
    }

    public DeploymentSettings deploymentSettings() {
        return this.deploymentSettings;
    }

    public DeploymentResourceProperties withDeploymentSettings(DeploymentSettings deploymentSettings) {
        this.deploymentSettings = deploymentSettings;
        return this;
    }

    public DeploymentResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentResourceStatus status() {
        return this.status;
    }

    public Boolean active() {
        return this.active;
    }

    public DeploymentResourceProperties withActive(Boolean active) {
        this.active = active;
        return this;
    }

    public List<DeploymentInstance> instances() {
        return this.instances;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.deploymentSettings() != null) {
            this.deploymentSettings().validate();
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeJsonField("deploymentSettings", (JsonSerializable)this.deploymentSettings);
        jsonWriter.writeBooleanField("active", this.active);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentResourceProperties)jsonReader.readObject(reader -> {
            DeploymentResourceProperties deserializedDeploymentResourceProperties = new DeploymentResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedDeploymentResourceProperties.source = UserSourceInfo.fromJson(reader);
                    continue;
                }
                if ("deploymentSettings".equals(fieldName)) {
                    deserializedDeploymentResourceProperties.deploymentSettings = DeploymentSettings.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDeploymentResourceProperties.provisioningState = DeploymentResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDeploymentResourceProperties.status = DeploymentResourceStatus.fromString(reader.getString());
                    continue;
                }
                if ("active".equals(fieldName)) {
                    deserializedDeploymentResourceProperties.active = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("instances".equals(fieldName)) {
                    List instances;
                    deserializedDeploymentResourceProperties.instances = instances = reader.readArray(reader1 -> DeploymentInstance.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentResourceProperties;
        });
    }
}

