/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class WorkloadProfile
implements JsonSerializable<WorkloadProfile> {
    private String name;
    private String workloadProfileType;
    private Integer minimumCount;
    private Integer maximumCount;
    private static final ClientLogger LOGGER = new ClientLogger(WorkloadProfile.class);

    public String name() {
        return this.name;
    }

    public WorkloadProfile withName(String name) {
        this.name = name;
        return this;
    }

    public String workloadProfileType() {
        return this.workloadProfileType;
    }

    public WorkloadProfile withWorkloadProfileType(String workloadProfileType) {
        this.workloadProfileType = workloadProfileType;
        return this;
    }

    public Integer minimumCount() {
        return this.minimumCount;
    }

    public WorkloadProfile withMinimumCount(Integer minimumCount) {
        this.minimumCount = minimumCount;
        return this;
    }

    public Integer maximumCount() {
        return this.maximumCount;
    }

    public WorkloadProfile withMaximumCount(Integer maximumCount) {
        this.maximumCount = maximumCount;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model WorkloadProfile"));
        }
        if (this.workloadProfileType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property workloadProfileType in model WorkloadProfile"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("workloadProfileType", this.workloadProfileType);
        jsonWriter.writeNumberField("minimumCount", (Number)this.minimumCount);
        jsonWriter.writeNumberField("maximumCount", (Number)this.maximumCount);
        return jsonWriter.writeEndObject();
    }

    public static WorkloadProfile fromJson(JsonReader jsonReader) throws IOException {
        return (WorkloadProfile)jsonReader.readObject(reader -> {
            WorkloadProfile deserializedWorkloadProfile = new WorkloadProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedWorkloadProfile.name = reader.getString();
                    continue;
                }
                if ("workloadProfileType".equals(fieldName)) {
                    deserializedWorkloadProfile.workloadProfileType = reader.getString();
                    continue;
                }
                if ("minimumCount".equals(fieldName)) {
                    deserializedWorkloadProfile.minimumCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maximumCount".equals(fieldName)) {
                    deserializedWorkloadProfile.maximumCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkloadProfile;
        });
    }
}

